/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jvoicexml.xml.IgnoringEntityResolver;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XmlDocument
implements Document,
Serializable {
    private static final long serialVersionUID = 2293026699195796236L;
    private transient Document document;
    private static final ThreadLocal<DocumentBuilder> LOCAL_BUILDER = new ThreadLocal<DocumentBuilder>(){

        @Override
        protected DocumentBuilder initialValue() {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(true);
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
                IgnoringEntityResolver resolver = new IgnoringEntityResolver();
                boolean resolveEntities = Boolean.getBoolean("org.jvoicexml.xml.resolveEntities");
                if (!resolveEntities) {
                    builder.setEntityResolver(resolver);
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            return builder;
        }
    };

    public XmlDocument() throws ParserConfigurationException {
        DocumentType prototype = this.getDoctype();
        DocumentBuilder builder = LOCAL_BUILDER.get();
        if (prototype == null) {
            this.document = builder.newDocument();
            if (this.document != null) {
                Node root = this.createRootNode();
                this.appendChild(root);
            }
        } else {
            DOMImplementation impl = builder.getDOMImplementation();
            DocumentType type = impl.createDocumentType(prototype.getName(), prototype.getPublicId(), prototype.getSystemId());
            this.document = impl.createDocument(this.getDefaultNamespaceURI(), prototype.getName(), type);
        }
    }

    public XmlDocument(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder builder = LOCAL_BUILDER.get();
        this.document = builder.parse(source);
    }

    public XmlDocument(Document doc) {
        Document current = doc;
        while (current instanceof XmlDocument) {
            XmlDocument xmldocument = (XmlDocument)current;
            if ((current = xmldocument.getDocument()) != null) continue;
            current = xmldocument;
            break;
        }
        this.document = current;
    }

    public final Document getDocument() {
        Document current = this.document;
        while (current instanceof XmlDocument) {
            XmlDocument xmldocument = (XmlDocument)current;
            if ((current = xmldocument.getDocument()) != null) continue;
            return xmldocument;
        }
        return this.document;
    }

    protected abstract XmlNodeFactory<?> getXmlNodefactory();

    protected abstract Node createRootNode();

    @Override
    public final Node appendChild(Node newChild) {
        Node insertChild;
        if (newChild instanceof XmlNode) {
            XmlNode xmlNode = (XmlNode)newChild;
            insertChild = xmlNode.getNode();
        } else {
            insertChild = newChild;
        }
        return this.document.appendChild(insertChild);
    }

    @Override
    public final Node cloneNode(boolean deep) {
        return this.document.cloneNode(deep);
    }

    @Override
    public final Attr createAttribute(String name) {
        return this.document.createAttribute(name);
    }

    @Override
    public final Attr createAttributeNS(String namespaceURI, String qualifiedName) {
        return this.document.createAttributeNS(namespaceURI, qualifiedName);
    }

    @Override
    public final CDATASection createCDATASection(String data) {
        return this.document.createCDATASection(data);
    }

    @Override
    public final Comment createComment(String data) {
        return this.document.createComment(data);
    }

    @Override
    public final DocumentFragment createDocumentFragment() {
        return this.document.createDocumentFragment();
    }

    @Override
    public final Element createElement(String tagName) {
        return this.document.createElement(tagName);
    }

    @Override
    public final Element createElementNS(String namespaceURI, String qualifiedName) {
        return this.document.createElementNS(namespaceURI, qualifiedName);
    }

    @Override
    public final EntityReference createEntityReference(String name) {
        return this.document.createEntityReference(name);
    }

    @Override
    public final ProcessingInstruction createProcessingInstruction(String target, String data) {
        return this.document.createProcessingInstruction(target, data);
    }

    @Override
    public final Text createTextNode(String data) {
        return this.document.createTextNode(data);
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return this.document.getAttributes();
    }

    @Override
    public final NodeList getChildNodes() {
        NodeList children = this.document.getChildNodes();
        return this.getXmlNodeList(children);
    }

    @Override
    public DocumentType getDoctype() {
        if (this.document == null) {
            return null;
        }
        return this.document.getDoctype();
    }

    @Override
    public final Element getDocumentElement() {
        return this.document.getDocumentElement();
    }

    @Override
    public final Element getElementById(String elementId) {
        return this.document.getElementById(elementId);
    }

    @Override
    public final NodeList getElementsByTagName(String tagname) {
        NodeList list = this.document.getElementsByTagName(tagname);
        return this.getXmlNodeList(list);
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.getXmlNodeList(this.document.getElementsByTagNameNS(namespaceURI, localName));
    }

    protected final Node getXmlNode(Node node) {
        XmlNodeFactory<?> factory = this.getXmlNodefactory();
        return factory.getXmlNode(node);
    }

    protected abstract NodeList getXmlNodeList(NodeList var1);

    @Override
    public final Node getFirstChild() {
        return this.getXmlNode(this.document.getFirstChild());
    }

    @Override
    public final DOMImplementation getImplementation() {
        return this.document.getImplementation();
    }

    @Override
    public final Node getLastChild() {
        return this.getXmlNode(this.document.getLastChild());
    }

    @Override
    public final String getLocalName() {
        return this.document.getLocalName();
    }

    @Override
    public final String getNamespaceURI() {
        if (this.document == null) {
            return this.getDefaultNamespaceURI();
        }
        return this.document.getNamespaceURI();
    }

    protected abstract String getDefaultNamespaceURI();

    @Override
    public final Node getNextSibling() {
        return this.getXmlNode(this.document.getNextSibling());
    }

    @Override
    public final String getNodeName() {
        return this.document.getNodeName();
    }

    @Override
    public final short getNodeType() {
        return this.document.getNodeType();
    }

    @Override
    public final String getNodeValue() {
        return this.document.getNodeValue();
    }

    @Override
    public final Document getOwnerDocument() {
        return this.document.getOwnerDocument();
    }

    @Override
    public final Node getParentNode() {
        return this.getXmlNode(this.document.getParentNode());
    }

    @Override
    public final String getPrefix() {
        return this.document.getPrefix();
    }

    @Override
    public final Node getPreviousSibling() {
        return this.getXmlNode(this.document.getPreviousSibling());
    }

    @Override
    public final boolean hasAttributes() {
        return this.document.hasAttributes();
    }

    @Override
    public final boolean hasChildNodes() {
        return this.document.hasChildNodes();
    }

    @Override
    public final Node importNode(Node importedNode, boolean deep) {
        return this.document.importNode(importedNode, deep);
    }

    @Override
    public final String getInputEncoding() {
        return this.document.getInputEncoding();
    }

    @Override
    public final String getXmlEncoding() {
        return this.document.getXmlEncoding();
    }

    @Override
    public final boolean getXmlStandalone() {
        return this.document.getXmlStandalone();
    }

    @Override
    public final void setXmlStandalone(boolean xmlStandalone) {
        this.document.setXmlStandalone(xmlStandalone);
    }

    @Override
    public final String getXmlVersion() {
        return this.document.getXmlVersion();
    }

    @Override
    public final void setXmlVersion(String xmlVersion) {
        this.document.setXmlVersion(xmlVersion);
    }

    @Override
    public final boolean getStrictErrorChecking() {
        return this.document.getStrictErrorChecking();
    }

    @Override
    public final void setStrictErrorChecking(boolean strictErrorChecking) {
        this.document.setStrictErrorChecking(strictErrorChecking);
    }

    @Override
    public final String getDocumentURI() {
        return this.document.getDocumentURI();
    }

    @Override
    public final void setDocumentURI(String documentURI) {
        this.document.setDocumentURI(documentURI);
    }

    @Override
    public final Node adoptNode(Node source) {
        return this.document.adoptNode(this.getRawNode(source));
    }

    @Override
    public final DOMConfiguration getDomConfig() {
        return this.document.getDomConfig();
    }

    @Override
    public final void normalizeDocument() {
        this.document.normalizeDocument();
    }

    @Override
    public final Node renameNode(Node n, String namespaceURI, String qualifiedName) {
        return this.document.renameNode(this.getRawNode(n), namespaceURI, qualifiedName);
    }

    @Override
    public final Node insertBefore(Node newChild, Node refChild) {
        return this.document.insertBefore(this.getRawNode(newChild), this.getRawNode(refChild));
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return this.document.isSupported(feature, version);
    }

    @Override
    public final void normalize() {
        this.document.normalize();
    }

    @Override
    public final Node removeChild(Node oldChild) {
        return this.document.removeChild(this.getRawNode(oldChild));
    }

    @Override
    public final Node replaceChild(Node newChild, Node oldChild) {
        return this.document.replaceChild(this.getRawNode(newChild), this.getRawNode(oldChild));
    }

    @Override
    public final void setNodeValue(String nodeValue) {
        this.document.setNodeValue(nodeValue);
    }

    @Override
    public final void setPrefix(String prefix) {
        this.document.setPrefix(prefix);
    }

    @Override
    public final String getBaseURI() {
        return this.document.getBaseURI();
    }

    @Override
    public final short compareDocumentPosition(Node other) {
        return this.document.compareDocumentPosition(this.getRawNode(other));
    }

    @Override
    public final String getTextContent() {
        return this.document.getTextContent();
    }

    @Override
    public final void setTextContent(String textContent) {
        this.document.setTextContent(textContent);
    }

    @Override
    public final boolean isSameNode(Node other) {
        return this.document.isSameNode(this.getRawNode(other));
    }

    @Override
    public final String lookupPrefix(String namespaceURI) {
        return this.document.lookupPrefix(namespaceURI);
    }

    @Override
    public final boolean isDefaultNamespace(String namespaceURI) {
        return this.document.isDefaultNamespace(namespaceURI);
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        return this.document.lookupNamespaceURI(prefix);
    }

    @Override
    public final boolean isEqualNode(Node arg) {
        return this.document.isEqualNode(arg);
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return this.document.getFeature(feature, version);
    }

    @Override
    public final Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.document.setUserData(key, data, handler);
    }

    @Override
    public final Object getUserData(String key) {
        return this.document.getUserData(key);
    }

    public final String toXml() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            String encoding = System.getProperty("jvoicexml.xml.encoding", "UTF-8");
            transformer.setOutputProperty("encoding", encoding);
            transformer.setOutputProperty("standalone", "yes");
            DocumentType type = this.getDoctype();
            if (type != null) {
                transformer.setOutputProperty("doctype-public", type.getPublicId());
                transformer.setOutputProperty("doctype-system", type.getSystemId());
            }
            DOMSource source = new DOMSource(this.document);
            transformer.transform(source, result);
            return out.toString(encoding);
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public final String toString() {
        try {
            return this.toXml();
        }
        catch (IOException ioe) {
            return super.toString();
        }
    }

    private Node getRawNode(Node arg) {
        Node rawNode;
        if (arg instanceof VoiceXmlNode) {
            VoiceXmlNode voiceXmlNode = (VoiceXmlNode)arg;
            rawNode = voiceXmlNode.getNode();
        } else {
            rawNode = arg;
        }
        return rawNode;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(buffer);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            String encoding = System.getProperty("jvoicexml.xml.encoding", "UTF-8");
            transformer.setOutputProperty("encoding", encoding);
            DOMSource source = new DOMSource(this);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage(), e);
        }
        out.writeLong(buffer.size());
        out.write(buffer.toByteArray());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = (int)in.readLong();
        byte[] buffer = new byte[size];
        int num = 0;
        while ((num += in.read(buffer, num, size - num)) < size) {
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
        InputSource source = new InputSource(stream);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(source);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

