/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.pls;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jvoicexml.xml.PlsNode;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.pls.Alias;
import org.jvoicexml.xml.pls.Example;
import org.jvoicexml.xml.pls.GenericPlsNode;
import org.jvoicexml.xml.pls.Grapheme;
import org.jvoicexml.xml.pls.Lexeme;
import org.jvoicexml.xml.pls.Lexicon;
import org.jvoicexml.xml.pls.Meta;
import org.jvoicexml.xml.pls.Metadata;
import org.jvoicexml.xml.pls.Phoneme;
import org.w3c.dom.Node;

final class PlsNodeFactory
implements XmlNodeFactory<PlsNode> {
    private static final Logger LOGGER = Logger.getLogger(PlsNodeFactory.class.getCanonicalName());
    private static final Map<String, PlsNode> NODES = new HashMap<String, PlsNode>();

    PlsNodeFactory() {
        NODES.put("#text", new Text(null, this));
    }

    @Override
    public PlsNode getXmlNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof PlsNode) {
            return (PlsNode)node;
        }
        String name = node.getNodeName();
        PlsNode plsXmlNode = NODES.get(name);
        if (plsXmlNode == null) {
            LOGGER.warning("cannot resolve node with name '" + name + "'");
            return new GenericPlsNode(node);
        }
        return (PlsNode)plsXmlNode.newInstance(node, this);
    }

    static {
        NODES.put("lexicon", new Lexicon());
        NODES.put("meta", new Meta());
        NODES.put("metadata", new Metadata());
        NODES.put("lexeme", new Lexeme());
        NODES.put("grapheme", new Grapheme());
        NODES.put("phoneme", new Phoneme());
        NODES.put("example", new Example());
        NODES.put("alias", new Alias());
    }
}

