/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.scxml;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jvoicexml.xml.ScxmlNode;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.scxml.Assign;
import org.jvoicexml.xml.scxml.Cancel;
import org.jvoicexml.xml.scxml.Content;
import org.jvoicexml.xml.scxml.Data;
import org.jvoicexml.xml.scxml.Datamodel;
import org.jvoicexml.xml.scxml.Donedata;
import org.jvoicexml.xml.scxml.Else;
import org.jvoicexml.xml.scxml.Elseif;
import org.jvoicexml.xml.scxml.Final;
import org.jvoicexml.xml.scxml.Finalize;
import org.jvoicexml.xml.scxml.Foreach;
import org.jvoicexml.xml.scxml.GenericScxmlNode;
import org.jvoicexml.xml.scxml.History;
import org.jvoicexml.xml.scxml.If;
import org.jvoicexml.xml.scxml.Initial;
import org.jvoicexml.xml.scxml.Invoke;
import org.jvoicexml.xml.scxml.Log;
import org.jvoicexml.xml.scxml.Onentry;
import org.jvoicexml.xml.scxml.Onexit;
import org.jvoicexml.xml.scxml.Parallel;
import org.jvoicexml.xml.scxml.Param;
import org.jvoicexml.xml.scxml.Raise;
import org.jvoicexml.xml.scxml.Script;
import org.jvoicexml.xml.scxml.Scxml;
import org.jvoicexml.xml.scxml.Send;
import org.jvoicexml.xml.scxml.State;
import org.jvoicexml.xml.scxml.Transition;
import org.jvoicexml.xml.scxml.Validate;
import org.w3c.dom.Node;

final class ScxmlNodeFactory
implements XmlNodeFactory<ScxmlNode> {
    private static final Logger LOGGER = Logger.getLogger(ScxmlNodeFactory.class.getCanonicalName());
    private static final Map<String, ScxmlNode> NODES = new HashMap<String, ScxmlNode>();

    ScxmlNodeFactory() {
        NODES.put("#text", new Text(null, this));
        NODES.put("assign", new Assign());
        NODES.put("cancel", new Cancel());
        NODES.put("content", new Content());
        NODES.put("datamodel", new Datamodel());
        NODES.put("data", new Data());
        NODES.put("donedata", new Donedata());
        NODES.put("else", new Else());
        NODES.put("elseif", new Elseif());
        NODES.put("final", new Final());
        NODES.put("finalize", new Finalize());
        NODES.put("foreach", new Foreach());
        NODES.put("history", new History());
        NODES.put("if", new If());
        NODES.put("initial", new Initial());
        NODES.put("invoke", new Invoke());
        NODES.put("log", new Log());
        NODES.put("onentry", new Onentry());
        NODES.put("onexit", new Onexit());
        NODES.put("parallel", new Parallel());
        NODES.put("param", new Param());
        NODES.put("raise", new Raise());
        NODES.put("send", new Send());
        NODES.put("script", new Script());
        NODES.put("scxml", new Scxml());
        NODES.put("state", new State());
        NODES.put("transition", new Transition());
        NODES.put("validate", new Validate());
    }

    @Override
    public ScxmlNode getXmlNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof ScxmlNode) {
            return (ScxmlNode)node;
        }
        String name = node.getNodeName();
        ScxmlNode scxmlNode = NODES.get(name);
        if (scxmlNode == null) {
            LOGGER.warning("cannot resolve node with name '" + name + "'");
            return new GenericScxmlNode(node);
        }
        return (ScxmlNode)scxmlNode.newInstance(node, this);
    }
}

