/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.srgs;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jvoicexml.xml.IllegalAttributeException;
import org.jvoicexml.xml.LanguageIdentifierConverter;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.TimeParser;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.srgs.AbstractSrgsNode;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.srgs.Rule;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class Grammar
extends AbstractSrgsNode
implements VoiceXmlNode {
    public static final String TAG_NAME = "grammar";
    public static final String DEFAULT_XMLNS = "http://www.w3.org/2001/06/grammar";
    public static final String ATTRIBUTE_XMLNS = "xmlns";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String DEFAULT_VERSION = "1.0";
    public static final String ATTRIBUTE_XML_LANG = "xml:lang";
    public static final String ATTRIBUTE_MODE = "mode";
    public static final String ATTRIBUTE_ROOT = "root";
    public static final String ATTRIBUTE_TAG_FORMAT = "tag-format";
    public static final String ATTRIBUTE_XML_BASE = "xml:base";
    public static final String ATTRIBUTE_SRC = "src";
    public static final String ATTRIBUTE_SCOPE = "scope";
    public static final String SCOPE_DOCUMENT = "document";
    public static final String SCOPE_DIALOG = "dialog";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_WEIGHT = "weight";
    public static final String ATTRIBUTE_FETCHHINT = "fetchhint";
    public static final String ATTRIBUTE_FETCHTIMEOUT = "fetchtimeout";
    public static final String ATTRIBUTE_MAXAGE = "maxage";
    public static final String ATTRIBUTE_MAXSTALE = "maxstale";
    public static final String ATTRIBUTE_SRCEXPR = "srcexpr";
    protected static final ArrayList<String> ATTRIBUTE_NAMES = new ArrayList();
    private static final Set<String> CHILD_TAGS;

    public Grammar() {
        super(null);
    }

    Grammar(Node node) {
        super(node);
        Node parent = this.getParentNode();
        if (parent == null) {
            this.setVersion(DEFAULT_VERSION);
            this.setAttribute(ATTRIBUTE_XMLNS, DEFAULT_XMLNS);
            this.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            this.setAttribute("xsi:schemaLocation", "http://www.w3.org/2001/06/grammar http://www.w3.org/TR/speech-grammar/grammar.xsd");
            String lang = this.getXmlLang();
            if (lang == null) {
                this.setXmlLang(Locale.getDefault());
            }
        }
    }

    private Grammar(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        super(n, factory);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public XmlNode newInstance(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        return new Grammar(n, factory);
    }

    public String getVersion() {
        return this.getAttribute(ATTRIBUTE_VERSION);
    }

    public void setVersion(String version) {
        this.setAttribute(ATTRIBUTE_VERSION, version);
    }

    public String getModename() {
        return this.getAttribute(ATTRIBUTE_MODE);
    }

    public ModeType getMode() {
        String mode = this.getModename();
        if (mode == null) {
            return null;
        }
        String str = mode.toUpperCase();
        return ModeType.valueOf(str);
    }

    public void setMode(String mode) {
        this.setAttribute(ATTRIBUTE_MODE, mode);
    }

    public void setMode(ModeType mode) {
        String modename = mode.getMode();
        this.setAttribute(ATTRIBUTE_MODE, modename);
    }

    public String getRoot() {
        return this.getAttribute(ATTRIBUTE_ROOT);
    }

    public void setRoot(String root) {
        this.setAttribute(ATTRIBUTE_ROOT, root);
    }

    public void setRoot(Rule rule) {
        String root = rule.getId();
        this.setRoot(root);
    }

    public Rule getRootRule() {
        String root = this.getRoot();
        if (root == null) {
            return null;
        }
        return this.getRule(root);
    }

    public Collection<Rule> getRules() {
        return this.getChildNodes(Rule.class);
    }

    public Collection<Rule> getPublicRules() {
        ArrayList<Rule> publicRules = new ArrayList<Rule>();
        Collection<Rule> rules = this.getChildNodes(Rule.class);
        for (Rule rule : rules) {
            if (!rule.isPublic()) continue;
            publicRules.add(rule);
        }
        return publicRules;
    }

    public Rule getRule(String name) {
        Collection<Rule> rules = this.getChildNodes(Rule.class);
        for (Rule rule : rules) {
            String id = rule.getId();
            if (!id.equals(name)) continue;
            return rule;
        }
        return null;
    }

    public String getTagFormat() {
        return this.getAttribute(ATTRIBUTE_TAG_FORMAT);
    }

    public void setTagFormat(String tagFormat) {
        this.setAttribute(ATTRIBUTE_TAG_FORMAT, tagFormat);
    }

    public String getXmlLang() {
        return this.getAttribute(ATTRIBUTE_XML_LANG);
    }

    public Locale getXmlLangObject() {
        String xmlLang = this.getXmlLang();
        return LanguageIdentifierConverter.toLocale(xmlLang);
    }

    public void setXmlLang(String xmlLang) {
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public void setXmlLang(Locale locale) {
        String xmlLang = LanguageIdentifierConverter.toLanguageIdentifier(locale);
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public String getXmlBase() {
        return this.getAttribute(ATTRIBUTE_XML_BASE);
    }

    public void setXmlBase(String xmlBase) {
        this.setAttribute(ATTRIBUTE_XML_BASE, xmlBase);
    }

    public String getSrc() {
        return this.getAttribute(ATTRIBUTE_SRC);
    }

    public URL getSrcUrl() throws MalformedURLException {
        String src = this.getAttribute(ATTRIBUTE_SRC);
        if (src == null) {
            return null;
        }
        return new URL(src);
    }

    public URI getSrcUri() throws URISyntaxException {
        String src = this.getAttribute(ATTRIBUTE_SRC);
        if (src == null) {
            return null;
        }
        return new URI(src);
    }

    public void setSrc(String src) {
        this.setAttribute(ATTRIBUTE_SRC, src);
    }

    public void setSrc(URL url) {
        String src = url.toString();
        this.setSrc(src);
    }

    public void setSrc(URI uri) {
        String src = uri.toString();
        this.setSrc(src);
    }

    public String getScope() {
        return this.getAttribute(ATTRIBUTE_SCOPE);
    }

    public void setScope(String scope) {
        this.setAttribute(ATTRIBUTE_SCOPE, scope);
    }

    public String getTypename() {
        return this.getAttribute(ATTRIBUTE_TYPE);
    }

    public GrammarType getType() {
        String type = this.getTypename();
        if (type == null) {
            return null;
        }
        return GrammarType.valueOfAttribute(type);
    }

    public void setType(String type) {
        this.setAttribute(ATTRIBUTE_TYPE, type);
    }

    public void setType(GrammarType type) {
        String str = type.getType();
        this.setType(str);
    }

    public String getWeight() {
        return this.getAttribute(ATTRIBUTE_TYPE);
    }

    public void setWeight(String weight) {
        this.setAttribute(ATTRIBUTE_WEIGHT, weight);
    }

    public String getFetchhint() {
        return this.getAttribute(ATTRIBUTE_FETCHHINT);
    }

    public void setFetchhint(String fetchhint) {
        this.setAttribute(ATTRIBUTE_FETCHHINT, fetchhint);
    }

    public String getFetchtimeout() {
        return this.getAttribute(ATTRIBUTE_FETCHTIMEOUT);
    }

    public long getFetchTimeoutAsMsec() {
        String timeout = this.getFetchtimeout();
        TimeParser parser = new TimeParser(timeout);
        return parser.parse();
    }

    public void setFetchtimeout(String fetchtimeout) {
        this.setAttribute(ATTRIBUTE_FETCHTIMEOUT, fetchtimeout);
    }

    public String getMaxage() {
        return this.getAttribute(ATTRIBUTE_MAXAGE);
    }

    public long getMaxageAsMsec() {
        String timeout = this.getMaxage();
        TimeParser parser = new TimeParser(timeout);
        return parser.parse();
    }

    public void setMaxage(String maxage) {
        this.setAttribute(ATTRIBUTE_MAXAGE, maxage);
    }

    public String getMaxstale() {
        return this.getAttribute(ATTRIBUTE_MAXSTALE);
    }

    public long getMaxstaleAsMsec() {
        String timeout = this.getMaxage();
        TimeParser parser = new TimeParser(timeout);
        return parser.parse();
    }

    public void setMaxstale(String maxstale) {
        this.setAttribute(ATTRIBUTE_MAXSTALE, maxstale);
    }

    public String getSrcexpr() {
        return this.getAttribute(ATTRIBUTE_SRCEXPR);
    }

    public void setSrcexpr(String srcexpr) {
        this.setAttribute(ATTRIBUTE_SRCEXPR, srcexpr);
    }

    public Text addText(String text) {
        Document document = this.getOwnerDocument();
        org.w3c.dom.Text node = document.createTextNode(text);
        Text textNode = new Text(node, this.getNodeFactory());
        this.appendChild(textNode);
        return textNode;
    }

    public CDATASection addCData(String data) {
        Document document = this.getOwnerDocument();
        CDATASection node = document.createCDATASection(data);
        this.appendChild(node);
        return node;
    }

    @Override
    protected boolean canContainChild(String tagName) {
        return CHILD_TAGS.contains(tagName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    public boolean isExternalGrammar() throws IllegalAttributeException {
        if (this.getSrc() != null) {
            if (this.getSrcexpr() != null) {
                throw new IllegalAttributeException("It's not allowed to provide src and srcexp attribute.");
            }
            if (this.hasChildNodes()) {
                throw new IllegalAttributeException("It's not allowed to provide src attribute and an inline grammar.");
            }
            return true;
        }
        if (this.getSrcexpr() != null) {
            if (this.hasChildNodes()) {
                throw new IllegalAttributeException("It's not allowed to provide srcexp attribute and an inline grammar.");
            }
            return true;
        }
        if (this.hasChildNodes()) {
            return false;
        }
        throw new IllegalAttributeException("Exactly one of src, srcexpr, or an inline grammar must be specified");
    }

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_FETCHHINT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_FETCHTIMEOUT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_MAXAGE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_MAXSTALE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_MODE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_ROOT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_SCOPE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_SRC);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_SRCEXPR);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_TAG_FORMAT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_TYPE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_VERSION);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_WEIGHT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XML_BASE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XML_LANG);
        CHILD_TAGS = new HashSet<String>();
        CHILD_TAGS.add("meta");
        CHILD_TAGS.add("metadata");
        CHILD_TAGS.add("lexicon");
        CHILD_TAGS.add("rule");
        CHILD_TAGS.add("tag");
    }
}

