/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.srgs;

import java.util.ServiceLoader;
import org.jvoicexml.xml.srgs.GrammarTypeFactory;
import org.jvoicexml.xml.srgs.JVoiceXmlGrammarTypeFactory;

public class GrammarType {
    public static final GrammarType JSGF = new GrammarType("application/x-jsgf", false);
    public static final GrammarType SRGS_ABNF = new GrammarType("application/srgs", false);
    public static final GrammarType SRGS_XML = new GrammarType("application/srgs+xml", true);
    public static final GrammarType GSL = new GrammarType("application/x-nuance-gsl", true);
    public static final GrammarType GSL_BINARY = new GrammarType("application/x-nuance-dynagram-binary", false);
    private final String type;
    private final boolean isXmlFormat;

    protected GrammarType(String name, boolean isXml) {
        this.type = name;
        this.isXmlFormat = isXml;
    }

    public final String getType() {
        return this.type;
    }

    public final boolean isXmlFormat() {
        return this.isXmlFormat;
    }

    public final String toString() {
        return this.type;
    }

    public static final GrammarType valueOfAttribute(String attribute) {
        ServiceLoader<GrammarTypeFactory> factories = ServiceLoader.load(GrammarTypeFactory.class);
        for (GrammarTypeFactory factory : factories) {
            GrammarType type = factory.getGrammarType(attribute);
            if (type == null) continue;
            return type;
        }
        JVoiceXmlGrammarTypeFactory factory = new JVoiceXmlGrammarTypeFactory();
        GrammarType type = factory.getGrammarType(attribute);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Unable to determine the grammar type for '" + attribute + "'");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isXmlFormat ? 1231 : 1237);
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GrammarType other = (GrammarType)obj;
        if (this.isXmlFormat != other.isXmlFormat) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

