/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.srgs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jvoicexml.xml.LanguageIdentifierConverter;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.srgs.AbstractSrgsNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class Item
extends AbstractSrgsNode
implements VoiceXmlNode {
    public static final String TAG_NAME = "item";
    public static final String ATTRIBUTE_REPEAT = "repeat";
    public static final String ATTRIBUTE_REPEAT_PROB = "repeatProb";
    public static final String ATTRIBUTE_WEIGHT = "weight";
    public static final String ATTRIBUTE_XML_LANG = "xml:lang";
    protected static final ArrayList<String> ATTRIBUTE_NAMES = new ArrayList();
    private static final Set<String> CHILD_TAGS;

    public Item() {
        super(null);
    }

    Item(Node node) {
        super(node);
    }

    private Item(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        super(n, factory);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public XmlNode newInstance(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        return new Item(n, factory);
    }

    public String getRepeat() {
        return this.getAttribute(ATTRIBUTE_REPEAT);
    }

    public int getMinRepeat() {
        String repeat = this.getRepeat();
        if (repeat == null) {
            return 1;
        }
        int pos = repeat.indexOf(45);
        if (pos < 0) {
            return Integer.parseInt(repeat);
        }
        String min = repeat.substring(0, pos);
        if (min.trim().length() == 0) {
            return 1;
        }
        return Integer.parseInt(min);
    }

    public int getMaxRepeat() {
        String repeat = this.getRepeat();
        if (repeat == null) {
            return 1;
        }
        int pos = repeat.indexOf(45);
        if (pos < 0) {
            return Integer.parseInt(repeat);
        }
        if (pos == repeat.length()) {
            return -1;
        }
        String max = repeat.substring(pos + 1);
        if (max.trim().length() == 0) {
            return -1;
        }
        return Integer.parseInt(max);
    }

    public void setRepeat(int repeat) {
        if (repeat < 1) {
            throw new IllegalArgumentException("Repitions (" + repeat + ") must be greater than 0");
        }
        String value = Integer.toString(repeat);
        this.setAttribute(ATTRIBUTE_REPEAT, value);
    }

    public void setRepeat(int min, int max) {
        if (min < 0) {
            throw new IllegalArgumentException("Repitions (" + min + ", " + max + ") must be greater than 0");
        }
        if (max > 0 && min > max) {
            throw new IllegalArgumentException("Minimal number of repitions (" + min + ") must not be greeater than max (" + max + ")");
        }
        StringBuilder str = new StringBuilder();
        str.append(min);
        str.append('-');
        if (max > 0) {
            str.append(max);
        }
        this.setAttribute(ATTRIBUTE_REPEAT, str.toString());
    }

    public void setRepeat(String repeat) {
        this.setAttribute(ATTRIBUTE_REPEAT, repeat);
    }

    public void setOptional() {
        this.setAttribute(ATTRIBUTE_REPEAT, "0-1");
    }

    public boolean isOptional() {
        String repeat = this.getRepeat();
        return "0-1".equals(repeat);
    }

    public String getRepeatProb() {
        return this.getAttribute(ATTRIBUTE_REPEAT_PROB);
    }

    public void setRepeatProb(String repeatProb) {
        this.setAttribute(ATTRIBUTE_REPEAT_PROB, repeatProb);
    }

    public String getWeight() {
        return this.getAttribute(ATTRIBUTE_WEIGHT);
    }

    public void setWeight(String weight) {
        this.setAttribute(ATTRIBUTE_WEIGHT, weight);
    }

    public String getXmlLang() {
        return this.getAttribute(ATTRIBUTE_XML_LANG);
    }

    public Locale getXmlLangObject() {
        String xmlLang = this.getXmlLang();
        return LanguageIdentifierConverter.toLocale(xmlLang);
    }

    public void setXmlLang(String xmlLang) {
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public void setXmlLang(Locale locale) {
        String xmlLang = LanguageIdentifierConverter.toLanguageIdentifier(locale);
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public Text addText(String text) {
        Document document = this.getOwnerDocument();
        org.w3c.dom.Text node = document.createTextNode(text);
        Text textNode = new Text(node, this.getNodeFactory());
        this.appendChild(textNode);
        return textNode;
    }

    @Override
    protected boolean canContainChild(String tagName) {
        return CHILD_TAGS.contains(tagName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_REPEAT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_REPEAT_PROB);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_WEIGHT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XML_LANG);
        CHILD_TAGS = new HashSet<String>();
        CHILD_TAGS.add("token");
        CHILD_TAGS.add("ruleref");
        CHILD_TAGS.add(TAG_NAME);
        CHILD_TAGS.add("one-of");
        CHILD_TAGS.add("tag");
    }
}

