/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.srgs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.srgs.AbstractSrgsNode;
import org.jvoicexml.xml.srgs.Rule;
import org.w3c.dom.Node;

public final class Ruleref
extends AbstractSrgsNode
implements VoiceXmlNode {
    public static final String TAG_NAME = "ruleref";
    public static final String ATTRIBUTE_URI = "uri";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_SPECIAL = "special";
    public static final String SPECIAL_VALUE_GARBAGE = "GARBAGE";
    public static final String SPECIAL_VALUE_NULL = "NULL";
    public static final String SPECIAL_VALUE_VOID = "VOID";
    protected static final ArrayList<String> ATTRIBUTE_NAMES = new ArrayList();
    private static final Set<String> CHILD_TAGS;

    public Ruleref() {
        super(null);
    }

    Ruleref(Node node) {
        super(node);
    }

    private Ruleref(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        super(n, factory);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public XmlNode newInstance(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        return new Ruleref(n, factory);
    }

    public String getUri() {
        return this.getAttribute(ATTRIBUTE_URI);
    }

    public URI getUriObject() throws URISyntaxException {
        String value = this.getUri();
        if (value == null) {
            return null;
        }
        return new URI(value);
    }

    public void setUri(String uri) {
        this.setAttribute(ATTRIBUTE_URI, uri);
    }

    public void setUri(URI uri) {
        String value = uri == null ? null : uri.toString();
        this.setUri(value);
    }

    public void setUri(Rule rule) {
        String uri = "#" + rule.getId();
        this.setAttribute(ATTRIBUTE_URI, uri);
    }

    public String getType() {
        return this.getAttribute(ATTRIBUTE_TYPE);
    }

    public void setType(String type) {
        this.setAttribute(ATTRIBUTE_TYPE, type);
    }

    public String getSpecial() {
        return this.getAttribute(ATTRIBUTE_SPECIAL);
    }

    public void setSpecial(String special) {
        this.setAttribute(ATTRIBUTE_SPECIAL, special);
    }

    public boolean isSpecialGarbage() {
        String specialValue = this.getSpecial();
        return SPECIAL_VALUE_GARBAGE.equals(specialValue);
    }

    public boolean isSpecialVoid() {
        String specialValue = this.getSpecial();
        return SPECIAL_VALUE_VOID.equals(specialValue);
    }

    public boolean isSpecialNull() {
        String specialValue = this.getSpecial();
        return SPECIAL_VALUE_NULL.equals(specialValue);
    }

    @Override
    protected boolean canContainChild(String tagName) {
        return CHILD_TAGS.contains(tagName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_SPECIAL);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_TYPE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_URI);
        CHILD_TAGS = new HashSet<String>();
    }
}

