/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.srgs;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jvoicexml.xml.SrgsNode;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.srgs.Example;
import org.jvoicexml.xml.srgs.GenericSrgsNode;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.Item;
import org.jvoicexml.xml.srgs.Lexicon;
import org.jvoicexml.xml.srgs.Meta;
import org.jvoicexml.xml.srgs.Metadata;
import org.jvoicexml.xml.srgs.OneOf;
import org.jvoicexml.xml.srgs.Rule;
import org.jvoicexml.xml.srgs.Ruleref;
import org.jvoicexml.xml.srgs.Tag;
import org.jvoicexml.xml.srgs.Token;
import org.w3c.dom.Node;

final class SrgsNodeFactory
implements XmlNodeFactory<SrgsNode> {
    private static final Logger LOGGER = Logger.getLogger(SrgsNodeFactory.class.getCanonicalName());
    private static final Map<String, SrgsNode> NODES = new HashMap<String, SrgsNode>();

    SrgsNodeFactory() {
        NODES.put("#text", new Text(null, this));
    }

    @Override
    public SrgsNode getXmlNode(Node node) {
        SrgsNode srgsXmlNode;
        if (node == null) {
            return null;
        }
        if (node instanceof SrgsNode) {
            return (SrgsNode)node;
        }
        String name = node.getLocalName();
        if (name == null) {
            name = node.getNodeName();
        }
        if ((srgsXmlNode = NODES.get(name)) == null) {
            LOGGER.warning("cannot resolve node with name '" + name + "'");
            return new GenericSrgsNode(node);
        }
        return (SrgsNode)srgsXmlNode.newInstance(node, this);
    }

    static {
        NODES.put("grammar", new Grammar());
        NODES.put("example", new Example());
        NODES.put("item", new Item());
        NODES.put("meta", new Meta());
        NODES.put("metadata", new Metadata());
        NODES.put("one-of", new OneOf());
        NODES.put("rule", new Rule());
        NODES.put("ruleref", new Ruleref());
        NODES.put("tag", new Tag());
        NODES.put("token", new Token());
        NODES.put("lexicon", new Lexicon());
    }
}

