/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.ssml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jvoicexml.xml.NodeHelper;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.TextContainer;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.ssml.AbstractSsmlNode;
import org.jvoicexml.xml.ssml.HertzParser;
import org.jvoicexml.xml.ssml.PercentageParser;
import org.w3c.dom.Node;

public final class Prosody
extends AbstractSsmlNode
implements VoiceXmlNode,
TextContainer {
    public static final String TAG_NAME = "prosody";
    public static final String ATTRIBUTE_PITCH = "pitch";
    public static final String PITCH_X_LOW = "x-low";
    public static final String PITCH_LOW = "low";
    public static final String PITCH_MEDIUM = "medium";
    public static final String PITCH_HIGH = "high";
    public static final String PITCH_X_HIGH = "x-high";
    public static final String PITCH_DEFAULT = "default";
    public static final String ATTRIBUTE_CONTOUR = "contour";
    public static final String ATTRIBUTE_RANGE = "range";
    public static final String RANGE_X_LOW = "x-low";
    public static final String RANGE_LOW = "low";
    public static final String RANGE_MEDIUM = "medium";
    public static final String RANGE_HIGH = "high";
    public static final String RANGE_X_HIGH = "x-high";
    public static final String RANGE_DEFAULT = "default";
    public static final String ATTRIBUTE_RATE = "rate";
    public static final String RATE_X_SLOW = "x-slow";
    public static final String RATE_SLOW = "slow";
    public static final String RATE_MEDIUM = "medium";
    public static final String RATE_FAST = "fast";
    public static final String RATE_X_FAST = "x-fast";
    public static final String RATE_DEFAULT = "default";
    public static final String ATTRIBUTE_DURATION = "duration";
    public static final String ATTRIBUTE_VOLUME = "volume";
    public static final String VOLUME_SILENT = "silent";
    public static final String VOLUME_X_SOFT = "x-soft";
    public static final String VOLUME_SOFT = "soft";
    public static final String VOLUME_MEDIUM = "medium";
    public static final String VOLUME_LOUD = "loud";
    public static final String VOLUME_X_LOUD = "x-loud";
    public static final String VOLUME_DEFAULT = "default";
    protected static final ArrayList<String> ATTRIBUTE_NAMES = new ArrayList();
    private static final Set<String> CHILD_TAGS;

    public Prosody() {
        super(null);
    }

    Prosody(Node node) {
        super(node);
    }

    private Prosody(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        super(n, factory);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public XmlNode newInstance(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        return new Prosody(n, factory);
    }

    @Override
    public Text addText(String text) {
        return NodeHelper.addText(this, text);
    }

    public String getPitch() {
        return this.getAttribute(ATTRIBUTE_PITCH);
    }

    public float getPitchFloat() {
        String value = this.getAttribute(ATTRIBUTE_PITCH);
        if (value == null) {
            throw new IllegalArgumentException("Pitch is not defined!");
        }
        return HertzParser.parse(value);
    }

    public void setPitch(String pitch) {
        this.setAttribute(ATTRIBUTE_PITCH, pitch);
    }

    public void setPitch(float pitch) {
        String value = pitch + "Hz";
        this.setAttribute(ATTRIBUTE_PITCH, value);
    }

    public String getContour() {
        return this.getAttribute(ATTRIBUTE_CONTOUR);
    }

    public void setContour(String contour) {
        this.setAttribute(ATTRIBUTE_CONTOUR, contour);
    }

    public String getRange() {
        return this.getAttribute(ATTRIBUTE_RANGE);
    }

    public void setRange(String range) {
        this.setAttribute(ATTRIBUTE_RANGE, range);
    }

    public String getRate() {
        return this.getAttribute(ATTRIBUTE_RATE);
    }

    public float getRateFloat() {
        String value = this.getAttribute(ATTRIBUTE_RATE);
        if (value == null) {
            return 100.0f;
        }
        return PercentageParser.parse(value);
    }

    public void setRate(String rate) {
        this.setAttribute(ATTRIBUTE_RATE, rate);
    }

    public void setRate(float rate) {
        String value = rate + "%";
        this.setAttribute(ATTRIBUTE_RATE, value);
    }

    public String getDuration() {
        return this.getAttribute(ATTRIBUTE_DURATION);
    }

    public void setDuration(String duration) {
        this.setAttribute(ATTRIBUTE_DURATION, duration);
    }

    public String getVolume() {
        return this.getAttribute(ATTRIBUTE_VOLUME);
    }

    public void setVolume(String volume) {
        this.setAttribute(ATTRIBUTE_VOLUME, volume);
    }

    @Override
    protected boolean canContainChild(String tagName) {
        return CHILD_TAGS.contains(tagName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_CONTOUR);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_DURATION);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_PITCH);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_RANGE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_RATE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_VOLUME);
        CHILD_TAGS = new HashSet<String>();
        CHILD_TAGS.add("audio");
        CHILD_TAGS.add("enumerate");
        CHILD_TAGS.add("value");
        CHILD_TAGS.add("break");
        CHILD_TAGS.add("emphasis");
        CHILD_TAGS.add("mark");
        CHILD_TAGS.add("phoneme");
        CHILD_TAGS.add(TAG_NAME);
        CHILD_TAGS.add("say-as");
        CHILD_TAGS.add("voice");
        CHILD_TAGS.add("sub");
        CHILD_TAGS.add("p");
        CHILD_TAGS.add("s");
    }
}

