/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.ssml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jvoicexml.xml.LanguageIdentifierConverter;
import org.jvoicexml.xml.NodeHelper;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.TextContainer;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.ssml.AbstractSsmlNode;
import org.w3c.dom.Node;

public final class Speak
extends AbstractSsmlNode
implements TextContainer {
    public static final String TAG_NAME = "speak";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String DEFAULT_VERSION = "1.0";
    public static final String DEFAULT_XMLNS = "http://www.w3.org/2001/10/synthesis";
    public static final String ATTRIBUTE_XMLNS = "xmlns";
    public static final String ATTRIBUTE_XML_LANG = "xml:lang";
    public static final String ATTRIBUTE_XML_BASE = "xml:base";
    protected static final ArrayList<String> ATTRIBUTE_NAMES = new ArrayList();
    private static final Set<String> CHILD_TAGS;

    public Speak() {
        super(null);
    }

    Speak(Node node) {
        super(node);
        this.setVersion(DEFAULT_VERSION);
        this.setAttribute(ATTRIBUTE_XMLNS, DEFAULT_XMLNS);
        this.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.setAttribute("xsi:schemaLocation", "http://www.w3.org/2001/10/synthesis http://www.w3.org/TR/speech-synthesis/synthesis.xsd");
        String lang = this.getXmlLang();
        if (lang == null) {
            this.setXmlLang(Locale.getDefault());
        }
    }

    private Speak(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        super(n, factory);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public XmlNode newInstance(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        return new Speak(n, factory);
    }

    @Override
    protected boolean canContainChild(String tagName) {
        return CHILD_TAGS.contains(tagName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    public String getXmlLang() {
        return this.getAttribute(ATTRIBUTE_XML_LANG);
    }

    public Locale getXmlLangObject() {
        String xmlLang = this.getXmlLang();
        return LanguageIdentifierConverter.toLocale(xmlLang);
    }

    public void setXmlLang(String xmlLang) {
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public void setXmlLang(Locale locale) {
        String xmlLang = LanguageIdentifierConverter.toLanguageIdentifier(locale);
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public String getVersion() {
        return this.getAttribute(ATTRIBUTE_VERSION);
    }

    public void setVersion(String version) {
        this.setAttribute(ATTRIBUTE_VERSION, version);
    }

    public String getXmlBase() {
        return this.getAttribute(ATTRIBUTE_XML_BASE);
    }

    public void setXmlBase(String xmlBase) {
        this.setAttribute(ATTRIBUTE_XML_BASE, xmlBase);
    }

    @Override
    public Text addText(String text) {
        return NodeHelper.addText(this, text);
    }

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_VERSION);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XML_LANG);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XML_BASE);
        CHILD_TAGS = new HashSet<String>();
        CHILD_TAGS.add("audio");
        CHILD_TAGS.add("break");
        CHILD_TAGS.add("emphasis");
        CHILD_TAGS.add("lexicon");
        CHILD_TAGS.add("mark");
        CHILD_TAGS.add("p");
        CHILD_TAGS.add("phoneme");
        CHILD_TAGS.add("prosody");
        CHILD_TAGS.add("sub");
        CHILD_TAGS.add("say-as");
        CHILD_TAGS.add("s");
        CHILD_TAGS.add("voice");
        CHILD_TAGS.add("#text");
    }
}

