/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.ssml;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.jvoicexml.xml.SsmlNode;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.ssml.Audio;
import org.jvoicexml.xml.ssml.Break;
import org.jvoicexml.xml.ssml.Desc;
import org.jvoicexml.xml.ssml.Emphasis;
import org.jvoicexml.xml.ssml.GenericSsmlNode;
import org.jvoicexml.xml.ssml.Lexicon;
import org.jvoicexml.xml.ssml.Mark;
import org.jvoicexml.xml.ssml.P;
import org.jvoicexml.xml.ssml.Phoneme;
import org.jvoicexml.xml.ssml.Prosody;
import org.jvoicexml.xml.ssml.S;
import org.jvoicexml.xml.ssml.SayAs;
import org.jvoicexml.xml.ssml.Speak;
import org.jvoicexml.xml.ssml.Sub;
import org.jvoicexml.xml.ssml.Voice;
import org.w3c.dom.Node;

final class SsmlNodeFactory
implements XmlNodeFactory<SsmlNode> {
    private static final Logger LOGGER = Logger.getLogger(SsmlNodeFactory.class.getCanonicalName());
    private static final Map<String, SsmlNode> NODES = new HashMap<String, SsmlNode>();

    SsmlNodeFactory() {
        NODES.put("#text", new Text(null, this));
    }

    @Override
    public SsmlNode getXmlNode(Node node) {
        if (node == null) {
            return null;
        }
        if (node instanceof SsmlNode) {
            return (SsmlNode)node;
        }
        String name = node.getNodeName();
        SsmlNode ssmlNode = NODES.get(name);
        if (ssmlNode == null) {
            LOGGER.warning("cannot resolve node with name '" + name + "'");
            return new GenericSsmlNode(node);
        }
        return (SsmlNode)ssmlNode.newInstance(node, this);
    }

    static {
        NODES.put("speak", new Speak());
        NODES.put("audio", new Audio());
        NODES.put("p", new P());
        NODES.put("s", new S());
        NODES.put("voice", new Voice());
        NODES.put("prosody", new Prosody());
        NODES.put("desc", new Desc());
        NODES.put("emphasis", new Emphasis());
        NODES.put("say-as", new SayAs());
        NODES.put("sub", new Sub());
        NODES.put("phoneme", new Phoneme());
        NODES.put("break", new Break());
        NODES.put("mark", new Mark());
        NODES.put("lexicon", new Lexicon());
    }
}

