/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.ssml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jvoicexml.xml.NodeHelper;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.TextContainer;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.ssml.AbstractSsmlNode;
import org.jvoicexml.xml.ssml.GenderType;
import org.w3c.dom.Node;

public final class Voice
extends AbstractSsmlNode
implements VoiceXmlNode,
TextContainer {
    public static final String TAG_NAME = "voice";
    public static final String ATTRIBUTE_XML_LANG = "xml:lang";
    public static final String ATTRIBUTE_GENDER = "gender";
    public static final String ATTRIBUTE_AGE = "age";
    public static final String ATTRIBUTE_VARIANT = "variant";
    public static final String ATTRIBUTE_NAME = "name";
    protected static final ArrayList<String> ATTRIBUTE_NAMES = new ArrayList();
    private static final Set<String> CHILD_TAGS;

    public Voice() {
        super(null);
    }

    Voice(Node node) {
        super(node);
    }

    private Voice(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        super(n, factory);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public XmlNode newInstance(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        return new Voice(n, factory);
    }

    public String getXmlLang() {
        return this.getAttribute(ATTRIBUTE_XML_LANG);
    }

    public void setXmlLang(String xmlLang) {
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public String getGenderName() {
        GenderType gender = this.getGender();
        if (gender == null) {
            return null;
        }
        return gender.getType();
    }

    public GenderType getGender() {
        String gender = this.getAttribute(ATTRIBUTE_GENDER);
        if (gender == null) {
            return null;
        }
        return GenderType.valueOf(gender);
    }

    public void setGender(String gender) {
        this.setAttribute(ATTRIBUTE_GENDER, gender);
    }

    public void setGender(GenderType gender) {
        String value = gender == null ? null : gender.getType();
        this.setGender(value);
    }

    public String getAge() {
        return this.getAttribute(ATTRIBUTE_AGE);
    }

    public int getAgeAsInt() {
        String age = this.getAge();
        if (age == null) {
            return -1;
        }
        return Integer.parseInt(age);
    }

    public void setAge(String age) {
        this.setAttribute(ATTRIBUTE_AGE, age);
    }

    public void setAge(int age) {
        String value = Integer.toString(age);
        this.setAge(value);
    }

    public String getVariant() {
        return this.getAttribute(ATTRIBUTE_VARIANT);
    }

    public void setVariant(String variant) {
        this.setAttribute(ATTRIBUTE_VARIANT, variant);
    }

    public String getName() {
        return this.getAttribute(ATTRIBUTE_NAME);
    }

    public void setName(String name) {
        this.setAttribute(ATTRIBUTE_NAME, name);
    }

    @Override
    public Text addText(String text) {
        return NodeHelper.addText(this, text);
    }

    @Override
    protected boolean canContainChild(String tagName) {
        return CHILD_TAGS.contains(tagName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_AGE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_GENDER);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_NAME);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_VARIANT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XML_LANG);
        CHILD_TAGS = new HashSet<String>();
        CHILD_TAGS.add("audio");
        CHILD_TAGS.add("enumerate");
        CHILD_TAGS.add("value");
        CHILD_TAGS.add("break");
        CHILD_TAGS.add("emphasis");
        CHILD_TAGS.add("mark");
        CHILD_TAGS.add("phoneme");
        CHILD_TAGS.add("prosody");
        CHILD_TAGS.add("say-as");
        CHILD_TAGS.add(TAG_NAME);
        CHILD_TAGS.add("sub");
        CHILD_TAGS.add("p");
        CHILD_TAGS.add("s");
    }
}

