/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.vxml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jvoicexml.xml.Text;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.vxml.AbstractVoiceXmlNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class ObjectTag
extends AbstractVoiceXmlNode {
    public static final String TAG_NAME = "object";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_EXPR = "expr";
    public static final String ATTRIBUTE_COND = "cond";
    public static final String ATTRIBUTE_CLASSID = "classid";
    public static final String ATTRIBUTE_CODEBASE = "codebase";
    public static final String ATTRIBUTE_CODETYPE = "codetype";
    public static final String ATTRIBUTE_DATA = "data";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_ARCHIVE = "archive";
    public static final String ATTRIBUTE_FETCHTIMEOUT = "fetchtimeout";
    public static final String ATTRIBUTE_FETCHHINT = "fetchhint";
    public static final String ATTRIBUTE_MAXAGE = "maxage";
    public static final String ATTRIBUTE_MAXSTALE = "maxstale";
    protected static final ArrayList<String> ATTRIBUTE_NAMES = new ArrayList();
    private static final Set<String> CHILD_TAGS;

    public ObjectTag() {
        super(null);
    }

    ObjectTag(Node node) {
        super(node);
    }

    private ObjectTag(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        super(n, factory);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public XmlNode newInstance(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        return new ObjectTag(n, factory);
    }

    public String getName() {
        return this.getAttribute(ATTRIBUTE_NAME);
    }

    public void setName(String name) {
        this.setAttribute(ATTRIBUTE_NAME, name);
    }

    public String getExpr() {
        return this.getAttribute(ATTRIBUTE_EXPR);
    }

    public void setExpr(String expr) {
        this.setAttribute(ATTRIBUTE_EXPR, expr);
    }

    public String getCond() {
        return this.getAttribute(ATTRIBUTE_COND);
    }

    public void setCond(String cond) {
        this.setAttribute(ATTRIBUTE_COND, cond);
    }

    public String getClassid() {
        return this.getAttribute(ATTRIBUTE_CLASSID);
    }

    public URI getClassidUri() throws URISyntaxException {
        String classid = this.getClassid();
        if (classid == null) {
            return null;
        }
        return new URI(classid);
    }

    public void setClassid(String classid) {
        this.setAttribute(ATTRIBUTE_CLASSID, classid);
    }

    public void setClassid(Class<?> classid) {
        this.setClassid(classid, null);
    }

    public void setClassid(Class<?> classid, String method) {
        StringBuilder str = new StringBuilder();
        str.append("method://");
        str.append(classid.getName());
        if (method != null) {
            str.append('#');
            str.append(method);
        }
        this.setClassid(str.toString());
    }

    public void setClassid(URI classid) {
        String id = classid == null ? null : classid.toString();
        this.setClassid(id);
    }

    public String getCodebase() {
        return this.getAttribute(ATTRIBUTE_CODEBASE);
    }

    public void setCodebase(String codebase) {
        this.setAttribute(ATTRIBUTE_CODEBASE, codebase);
    }

    public String getCodetype() {
        return this.getAttribute(ATTRIBUTE_CODETYPE);
    }

    public void setCodetype(String codetype) {
        this.setAttribute(ATTRIBUTE_CODETYPE, codetype);
    }

    public String getData() {
        return this.getAttribute(ATTRIBUTE_DATA);
    }

    public URI getDataUri() throws URISyntaxException {
        String data = this.getData();
        if (data == null) {
            return null;
        }
        return new URI(data);
    }

    public void setData(String data) {
        this.setAttribute(ATTRIBUTE_DATA, data);
    }

    public void setData(URI data) {
        String value = data == null ? null : data.toString();
        this.setData(value);
    }

    public String getType() {
        return this.getAttribute(ATTRIBUTE_TYPE);
    }

    public void setType(String type) {
        this.setAttribute(ATTRIBUTE_TYPE, type);
    }

    public String getArchive() {
        return this.getAttribute(ATTRIBUTE_ARCHIVE);
    }

    public Collection<URI> getArchiveUris() throws URISyntaxException {
        String archive = this.getArchive();
        if (archive == null) {
            return null;
        }
        String[] entries = archive.split(",");
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String entry : entries) {
            URI uri = new URI(entry.trim());
            uris.add(uri);
        }
        return uris;
    }

    public void setArchive(String archive) {
        this.setAttribute(ATTRIBUTE_ARCHIVE, archive);
    }

    public void setArchive(Collection<URI> uris) {
        if (uris == null) {
            this.setAttribute(ATTRIBUTE_ARCHIVE, null);
            return;
        }
        StringBuilder str = new StringBuilder();
        for (URI uri : uris) {
            String s = uri.toString();
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(s);
        }
        this.setArchive(str.toString());
    }

    public String getFetchhint() {
        return this.getAttribute(ATTRIBUTE_FETCHHINT);
    }

    public void setFetchhint(String fetchhint) {
        this.setAttribute(ATTRIBUTE_FETCHHINT, fetchhint);
    }

    public String getFetchtimeout() {
        return this.getAttribute(ATTRIBUTE_FETCHTIMEOUT);
    }

    public void setFetchtimeout(String fetchtimeout) {
        this.setAttribute(ATTRIBUTE_FETCHTIMEOUT, fetchtimeout);
    }

    public String getMaxage() {
        return this.getAttribute(ATTRIBUTE_MAXAGE);
    }

    public void setMaxage(String maxage) {
        this.setAttribute(ATTRIBUTE_MAXAGE, maxage);
    }

    public String getMaxstale() {
        return this.getAttribute(ATTRIBUTE_MAXSTALE);
    }

    public void setMaxstale(String maxstale) {
        this.setAttribute(ATTRIBUTE_MAXSTALE, maxstale);
    }

    public Text addText(String text) {
        Document document = this.getOwnerDocument();
        org.w3c.dom.Text node = document.createTextNode(text);
        Text textNode = new Text(node, this.getNodeFactory());
        this.appendChild(textNode);
        return textNode;
    }

    @Override
    protected boolean canContainChild(String tagName) {
        return CHILD_TAGS.contains(tagName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_ARCHIVE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_CLASSID);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_CODEBASE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_CODETYPE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_COND);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_DATA);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_EXPR);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_FETCHHINT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_FETCHTIMEOUT);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_MAXAGE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_MAXSTALE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_NAME);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_TYPE);
        CHILD_TAGS = new HashSet<String>();
        CHILD_TAGS.add("enumerate");
        CHILD_TAGS.add("value");
        CHILD_TAGS.add("audio");
        CHILD_TAGS.add("catch");
        CHILD_TAGS.add("help");
        CHILD_TAGS.add("noinput");
        CHILD_TAGS.add("nomatch");
        CHILD_TAGS.add("error");
        CHILD_TAGS.add("filled");
        CHILD_TAGS.add("param");
        CHILD_TAGS.add("prompt");
        CHILD_TAGS.add("property");
    }
}

