/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.vxml;

import java.io.IOException;
import java.io.Serializable;
import javax.xml.parsers.ParserConfigurationException;
import org.jvoicexml.xml.DocumentTypeFactory;
import org.jvoicexml.xml.VoiceXmlNode;
import org.jvoicexml.xml.XmlDocument;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.XmlNodeList;
import org.jvoicexml.xml.vxml.VoiceXml20DocumentType;
import org.jvoicexml.xml.vxml.VoiceXml21DocumentType;
import org.jvoicexml.xml.vxml.VoiceXmlNodeFactory;
import org.jvoicexml.xml.vxml.Vxml;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class VoiceXmlDocument
extends XmlDocument
implements Serializable {
    private static final long serialVersionUID = -5627050459434472927L;
    static final String VXML_VERSION = "jvoicexml.vxml.version";
    private static final transient VoiceXmlNodeFactory NODE_FACTORY = new VoiceXmlNodeFactory();
    private static transient DocumentTypeFactory documentTypeFactory;
    private transient DocumentType documentType;

    public VoiceXmlDocument() throws ParserConfigurationException {
        Vxml vxml = this.getVxml();
        vxml.addDefaultAttributes();
    }

    public VoiceXmlDocument(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        super(source);
    }

    public VoiceXmlDocument(Document doc) {
        super(doc);
    }

    public static void setDocumentTypeFactory(DocumentTypeFactory factory) {
        documentTypeFactory = factory;
    }

    @Override
    public DocumentType getDoctype() {
        DocumentType doctype;
        if (this.documentType != null) {
            return this.documentType;
        }
        Document doc = this.getDocument();
        if (doc != null && (doctype = doc.getDoctype()) != null) {
            this.documentType = doctype;
            return doctype;
        }
        if (documentTypeFactory != null) {
            this.documentType = documentTypeFactory.createDocumentType(this);
        } else {
            String version = System.getProperty(VXML_VERSION);
            if (version != null) {
                if (version.equals("2.0")) {
                    this.documentType = new VoiceXml20DocumentType();
                } else if (version.equals("2.1")) {
                    this.documentType = new VoiceXml21DocumentType();
                } else {
                    throw new IllegalArgumentException("environment variable jvoicexml.vxml.version must be set to 2.0 or 2.1!");
                }
            }
        }
        return this.documentType;
    }

    @Override
    public XmlNodeFactory<?> getXmlNodefactory() {
        return NODE_FACTORY;
    }

    @Override
    protected Node createRootNode() {
        Document document = this.getDocument();
        Element node = document.createElement("vxml");
        return new Vxml(node);
    }

    public Vxml getVxml() {
        NodeList vxml = this.getElementsByTagName("vxml");
        if (vxml.getLength() == 0 && (vxml = this.getElementsByTagNameNS("*", "vxml")).getLength() == 0) {
            return null;
        }
        return (Vxml)vxml.item(0);
    }

    @Override
    protected NodeList getXmlNodeList(NodeList nodeList) {
        return new XmlNodeList<VoiceXmlNode>(NODE_FACTORY, nodeList);
    }

    @Override
    protected String getDefaultNamespaceURI() {
        return "http://www.w3.org/2001/vxml";
    }
}

