/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.xml.vxml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jvoicexml.xml.LanguageIdentifierConverter;
import org.jvoicexml.xml.XmlNode;
import org.jvoicexml.xml.XmlNodeFactory;
import org.jvoicexml.xml.vxml.AbstractVoiceXmlNode;
import org.jvoicexml.xml.vxml.Form;
import org.jvoicexml.xml.vxml.Var;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class Vxml
extends AbstractVoiceXmlNode {
    public static final String TAG_NAME = "vxml";
    public static final String DEFAULT_VERSION = "2.1";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String DEFAULT_XMLNS = "http://www.w3.org/2001/vxml";
    public static final String ATTRIBUTE_XMLNS = "xmlns";
    public static final String ATTRIBUTE_XML_BASE = "xml:base";
    public static final String ATTRIBUTE_XML_LANG = "xml:lang";
    public static final String ATTRIBUTE_APPLICATION = "application";
    protected static final ArrayList<String> ATTRIBUTE_NAMES = new ArrayList();
    private static final Set<String> CHILD_TAGS;

    public Vxml() {
        super(null);
    }

    public Vxml(Node node) {
        super(node);
        this.setAttribute(ATTRIBUTE_XMLNS, DEFAULT_XMLNS);
        this.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.setAttribute("xsi:schematicLocation", "http://www.w3.org/2001/vxml http://www.w3.org/TR/voicexml20/vxml.xsd");
    }

    private Vxml(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        super(n, factory);
    }

    void addDefaultAttributes() {
        this.setAttribute(ATTRIBUTE_XMLNS, DEFAULT_XMLNS);
        this.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.setAttribute("xsi:schematicLocation", "http://www.w3.org/2001/vxml http://www.w3.org/TR/voicexml20/vxml.xsd");
        String version = System.getProperty("jvoicexml.vxml.version", DEFAULT_VERSION);
        this.setVersion(version);
        Locale lang = Locale.getDefault();
        this.setXmlLang(lang);
    }

    public List<Form> getForms() {
        VoiceXmlDocument document = new VoiceXmlDocument(this.getOwnerDocument());
        NodeList list = document.getElementsByTagName("form");
        ArrayList<Form> forms = new ArrayList<Form>();
        for (int i = 0; i < list.getLength(); ++i) {
            Form form = (Form)list.item(i);
            forms.add(form);
        }
        return forms;
    }

    public Map<String, Form> getFormMap() {
        HashMap<String, Form> map = new HashMap<String, Form>();
        VoiceXmlDocument document = new VoiceXmlDocument(this.getOwnerDocument());
        NodeList list = document.getElementsByTagName("form");
        for (int i = 0; i < list.getLength(); ++i) {
            Form form = (Form)list.item(i);
            String id = form.getId();
            if (id == null) continue;
            map.put(id, form);
        }
        return map;
    }

    public Map<String, Var> getVarMap() {
        HashMap<String, Var> map = new HashMap<String, Var>();
        VoiceXmlDocument document = new VoiceXmlDocument(this.getOwnerDocument());
        NodeList list = document.getElementsByTagName("var");
        for (int i = 0; i < list.getLength(); ++i) {
            Var var = (Var)list.item(i);
            String name = var.getName();
            if (name == null) continue;
            map.put(name, var);
        }
        return map;
    }

    public String getVersion() {
        return this.getAttribute(ATTRIBUTE_VERSION);
    }

    public void setVersion(String version) {
        this.setAttribute(ATTRIBUTE_VERSION, version);
    }

    public String getXmlns() {
        return this.getAttribute(ATTRIBUTE_XMLNS);
    }

    public void setXmlns(String xmlns) {
        this.setAttribute(DEFAULT_XMLNS, xmlns);
    }

    public String getXmlBase() {
        return this.getAttribute(ATTRIBUTE_XML_BASE);
    }

    public URI getXmlBaseUri() throws URISyntaxException {
        String base = this.getXmlBase();
        if (base == null) {
            return null;
        }
        return new URI(base);
    }

    public void setXmlBase(String xmlBase) {
        this.setAttribute(ATTRIBUTE_XML_BASE, xmlBase);
    }

    public void setXmlBase(URI xmlBase) {
        String base = xmlBase == null ? null : xmlBase.toString();
        this.setXmlBase(base);
    }

    public String getXmlLang() {
        return this.getAttribute(ATTRIBUTE_XML_LANG);
    }

    public Locale getXmlLangObject() {
        String xmlLang = this.getXmlLang();
        return LanguageIdentifierConverter.toLocale(xmlLang);
    }

    public void setXmlLang(String xmlLang) {
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public void setXmlLang(Locale locale) {
        String xmlLang = LanguageIdentifierConverter.toLanguageIdentifier(locale);
        this.setAttribute(ATTRIBUTE_XML_LANG, xmlLang);
    }

    public String getApplication() {
        return this.getAttribute(ATTRIBUTE_APPLICATION);
    }

    public URI getApplicationUri() throws URISyntaxException {
        String application = this.getApplication();
        if (application == null) {
            return null;
        }
        return new URI(application);
    }

    public void setApplication(String application) {
        this.setAttribute(ATTRIBUTE_APPLICATION, application);
    }

    public void setApplication(URI application) {
        if (application == null) {
            return;
        }
        String app = application.toString();
        this.setApplication(app);
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public XmlNode newInstance(Node n, XmlNodeFactory<? extends XmlNode> factory) {
        return new Vxml(n, factory);
    }

    @Override
    protected boolean canContainChild(String tagName) {
        return CHILD_TAGS.contains(tagName);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return ATTRIBUTE_NAMES;
    }

    static {
        ATTRIBUTE_NAMES.add(ATTRIBUTE_APPLICATION);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_VERSION);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XML_BASE);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XML_LANG);
        ATTRIBUTE_NAMES.add(ATTRIBUTE_XMLNS);
        CHILD_TAGS = new HashSet<String>();
        CHILD_TAGS.add("catch");
        CHILD_TAGS.add("data");
        CHILD_TAGS.add("help");
        CHILD_TAGS.add("noinput");
        CHILD_TAGS.add("nomatch");
        CHILD_TAGS.add("error");
        CHILD_TAGS.add("link");
        CHILD_TAGS.add("menu");
        CHILD_TAGS.add("meta");
        CHILD_TAGS.add("metadata");
        CHILD_TAGS.add("property");
        CHILD_TAGS.add("script");
        CHILD_TAGS.add("var");
        CHILD_TAGS.add("form");
    }
}

