/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jvoicexml.FetchAttributes;
import org.jvoicexml.interpreter.datamodel.KeyValuePair;
import org.jvoicexml.xml.vxml.RequestMethod;

public final class DocumentDescriptor {
    private URI uri;
    private final RequestMethod method;
    private FetchAttributes attributes;
    private final Collection<KeyValuePair> parameters;
    private final boolean forceLoad;

    public DocumentDescriptor(URI documentUri) {
        this(documentUri, RequestMethod.GET, false);
    }

    public DocumentDescriptor(URI documentUri, RequestMethod requestMethod) {
        this(documentUri, requestMethod, false);
    }

    public DocumentDescriptor(URI documentUri, RequestMethod requestMethod, boolean force) {
        this.uri = documentUri;
        this.method = requestMethod;
        this.parameters = new ArrayList<KeyValuePair>();
        this.forceLoad = force;
    }

    public void setURI(URI value) {
        this.uri = value;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isForceLoad() {
        return this.forceLoad;
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public FetchAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(FetchAttributes value) {
        this.attributes = value;
    }

    public void addParameters(Collection<KeyValuePair> pairs) {
        this.parameters.addAll(pairs);
    }

    public void addParameter(KeyValuePair pair) {
        this.parameters.add(pair);
    }

    public void addParamater(String key, Object value) {
        KeyValuePair pair = new KeyValuePair(key, value);
        this.addParameter(pair);
    }

    public void addParameters(Map<String, Object> parameters) {
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            this.addParamater(key, value);
        }
    }

    public Collection<KeyValuePair> getParameters() {
        return this.parameters;
    }
}

