/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.CallManager;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConfigurationException;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.ImplementationPlatformFactory;
import org.jvoicexml.InterpreterState;
import org.jvoicexml.JVoiceXml;
import org.jvoicexml.JVoiceXmlCore;
import org.jvoicexml.JVoiceXmlMainListener;
import org.jvoicexml.JVoiceXmlShutdownHook;
import org.jvoicexml.JndiSupport;
import org.jvoicexml.Session;
import org.jvoicexml.ShutdownWaiter;
import org.jvoicexml.event.ErrorEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.interpreter.GrammarProcessor;
import org.jvoicexml.interpreter.JVoiceXmlSession;
import org.jvoicexml.profile.Profile;

public final class JVoiceXmlMain
extends Thread
implements JVoiceXmlCore {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlMain.class);
    private final Object shutdownSemaphore;
    private ImplementationPlatformFactory implementationPlatformFactory;
    private DocumentServer documentServer;
    private GrammarProcessor grammarProcessor;
    private JndiSupport jndi;
    private Collection<CallManager> callManagers;
    private final Map<String, Profile> profiles;
    private Thread shutdownHook;
    private ShutdownWaiter shutdownWaiter;
    private Configuration configuration;
    private final Collection<JVoiceXmlMainListener> listeners;
    private InterpreterState state;

    public JVoiceXmlMain() {
        this((Configuration)null);
    }

    public JVoiceXmlMain(Configuration config) {
        LOGGER.info("----------------------------------------------------");
        LOGGER.info("starting VoiceXML interpreter " + this.getVersion() + "...");
        this.shutdownSemaphore = new Object();
        this.setName(JVoiceXmlMain.class.getSimpleName());
        this.configuration = config;
        this.listeners = new ArrayList<JVoiceXmlMainListener>();
        this.profiles = new HashMap<String, Profile>();
        this.state = InterpreterState.STARTED;
        LOGGER.info("interpreter state " + (Object)((Object)this.state));
    }

    @Override
    public String getVersion() {
        InputStream in = JVoiceXml.class.getResourceAsStream("/jvoicexml.version");
        if (in == null) {
            return "unmanaged version";
        }
        Properties props = new Properties();
        try {
            props.load(in);
        }
        catch (IOException e) {
            return "unmanaged version";
        }
        return props.getProperty("jvxml.version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JVoiceXmlMainListener listener) {
        Collection<JVoiceXmlMainListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JVoiceXmlMainListener listener) {
        Collection<JVoiceXmlMainListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public Session createSession(ConnectionInformation info) throws ErrorEvent {
        String profileName;
        Profile profile;
        if (this.state != InterpreterState.RUNNING) {
            throw new NoresourceError("JVoiceXML not running. Can't create a session!");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("creating new session...");
        }
        if ((profile = this.profiles.get(profileName = info.getProfile())) == null) {
            throw new BadFetchError("Unable to find a profile named '" + profileName + "'");
        }
        ImplementationPlatform platform = this.implementationPlatformFactory.getImplementationPlatform(info);
        JVoiceXmlSession session = new JVoiceXmlSession(platform, this, info, profile);
        platform.setSession(session);
        LOGGER.info("created session " + session.getSessionId());
        return session;
    }

    @Override
    public Configuration getConfiguration() {
        if (this.configuration == null) {
            ServiceLoader<Configuration> services = ServiceLoader.load(Configuration.class);
            try {
                Iterator<Configuration> iterator = services.iterator();
                if (iterator.hasNext()) {
                    Configuration config;
                    this.configuration = config = iterator.next();
                }
            }
            catch (ServiceConfigurationError e) {
                LOGGER.error("unable to load configuration", (Throwable)e);
            }
        }
        return this.configuration;
    }

    @Override
    public DocumentServer getDocumentServer() {
        return this.documentServer;
    }

    @Override
    public GrammarProcessor getGrammarProcessor() {
        return this.grammarProcessor;
    }

    public void setImplementationPlatformFactory(ImplementationPlatformFactory factory) {
        this.implementationPlatformFactory = factory;
    }

    public void setGrammarProcessor(GrammarProcessor processor) {
        this.grammarProcessor = processor;
    }

    public void setCallManager(Collection<CallManager> managers) throws IOException, NoresourceError {
        this.callManagers = managers;
        for (CallManager manager : this.callManagers) {
            manager.setJVoiceXml(this);
            manager.start();
            LOGGER.info("started call manager '" + manager + "'");
        }
    }

    @Override
    public void run() {
        this.state = InterpreterState.ALLOCATING_RESOURCES;
        LOGGER.info("interpreter state " + (Object)((Object)this.state));
        Configuration config = this.getConfiguration();
        if (config == null) {
            ConfigurationException exception = new ConfigurationException("no configuration available");
            this.abortStartup(exception);
            return;
        }
        LOGGER.info("using configuration '" + config.getClass().getCanonicalName() + "'");
        this.shutdownWaiter = new ShutdownWaiter(this);
        this.addShutdownHook();
        try {
            ConfigurationException exception;
            this.documentServer = config.loadObject(DocumentServer.class);
            if (this.documentServer == null) {
                exception = new ConfigurationException("no document server available");
                this.abortStartup(exception);
            }
            this.documentServer.start();
            this.implementationPlatformFactory = this.configuration.loadObject(ImplementationPlatformFactory.class);
            if (this.implementationPlatformFactory == null) {
                exception = new ConfigurationException("no implementation factory available");
                this.abortStartup(exception);
            }
            this.implementationPlatformFactory.init(config);
            this.grammarProcessor = config.loadObject(GrammarProcessor.class);
            if (this.grammarProcessor == null) {
                exception = new ConfigurationException("no grammar processor available");
                this.abortStartup(exception);
            }
            this.grammarProcessor.init(config);
            this.initCallManager(config);
            this.initProfiles(config);
            this.initJndi(config);
        }
        catch (Exception | NoresourceError e) {
            this.abortStartup(e);
            return;
        }
        this.shutdownWaiter.start();
        this.state = InterpreterState.RUNNING;
        LOGGER.info("interpreter state " + (Object)((Object)this.state));
        LOGGER.info("VoiceXML interpreter " + this.getVersion() + " started.");
        this.fireJVoiceXmlStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortStartup(Throwable exception) {
        LOGGER.fatal(exception.getMessage(), exception);
        this.fireJVoiceXmlStartupError(exception);
        Object object = this.shutdownSemaphore;
        synchronized (object) {
            this.shutdownSemaphore.notifyAll();
        }
    }

    private void initJndi(Configuration config) throws IOException, ConfigurationException {
        Collection<JndiSupport> jndis = config.loadObjects(JndiSupport.class, "jndi");
        if (jndis == null) {
            return;
        }
        if (jndis.size() > 0) {
            Iterator<JndiSupport> iterator = jndis.iterator();
            this.jndi = iterator.next();
            this.jndi.setJVoiceXml(this);
            this.jndi.startup();
        }
    }

    private void initCallManager(Configuration config) throws NoresourceError, IOException, ConfigurationException {
        this.callManagers = config.loadObjects(CallManager.class, "callmanager");
        if (this.callManagers == null) {
            return;
        }
        for (CallManager manager : this.callManagers) {
            manager.setJVoiceXml(this);
            manager.start();
            LOGGER.info("started call manager '" + manager + "'");
        }
    }

    private void initProfiles(Configuration config) throws NoresourceError, IOException, ConfigurationException {
        Collection<Profile> loadedProfiles = config.loadObjects(Profile.class, "profile");
        if (loadedProfiles != null) {
            for (Profile profile : loadedProfiles) {
                String name = profile.getName();
                this.profiles.put(name, profile);
                LOGGER.info("added profile '" + name + "'");
            }
        }
        if (this.profiles.isEmpty()) {
            LOGGER.warn("no profiles available");
        } else {
            LOGGER.info("available profiles:");
            for (String name : this.profiles.keySet()) {
                Profile profile = this.profiles.get(name);
                LOGGER.info("- '" + profile.getName() + "'");
            }
        }
    }

    private void shutdownCallManager() {
        for (CallManager manager : this.callManagers) {
            manager.stop();
            LOGGER.info("stopped call manager '" + manager + "'");
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.state == InterpreterState.DEALLOCATING_RESOURCES || this.state == InterpreterState.STOPPED) {
            return;
        }
        if (this.shutdownWaiter == null) {
            return;
        }
        LOGGER.info("received shutdown request");
        this.shutdownWaiter.triggerShutdown();
        this.shutdownWaiter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdownSequence() {
        LOGGER.info("shutting down JVoiceXml...");
        this.state = InterpreterState.DEALLOCATING_RESOURCES;
        LOGGER.info("interpreter state " + (Object)((Object)this.state));
        this.removeShutdownHook();
        this.shutdownCallManager();
        if (this.jndi != null) {
            this.jndi.shutdown();
            this.jndi = null;
        }
        this.grammarProcessor = null;
        this.documentServer = null;
        if (this.implementationPlatformFactory != null) {
            this.implementationPlatformFactory.close();
            this.implementationPlatformFactory = null;
        }
        this.state = InterpreterState.STOPPED;
        LOGGER.info("interpreter state " + (Object)((Object)this.state));
        LOGGER.info("shutdown of JVoiceXML complete!");
        Object object = this.shutdownSemaphore;
        synchronized (object) {
            this.shutdownSemaphore.notifyAll();
        }
        this.fireJVoiceXmlTerminated();
    }

    private void addShutdownHook() {
        JVoiceXmlShutdownHook hook = new JVoiceXmlShutdownHook(this);
        this.shutdownHook = new Thread(hook);
        this.shutdownHook.setName("ShutdownHook");
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(this.shutdownHook);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("added shutdown hook");
        }
    }

    private void removeShutdownHook() {
        if (this.shutdownHook == null) {
            return;
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            runtime.removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException e) {
            LOGGER.debug("shutdown already in process");
        }
        this.shutdownHook = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("removed shutdown hook");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitShutdownComplete() {
        try {
            Object object = this.shutdownSemaphore;
            synchronized (object) {
                this.shutdownSemaphore.wait();
            }
        }
        catch (InterruptedException ie) {
            LOGGER.error("wait shutdown event was interrupted", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJVoiceXmlStartupError(Throwable exception) {
        Collection<JVoiceXmlMainListener> collection = this.listeners;
        synchronized (collection) {
            for (JVoiceXmlMainListener listener : this.listeners) {
                listener.jvxmlStartupError(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJVoiceXmlStarted() {
        Collection<JVoiceXmlMainListener> collection = this.listeners;
        synchronized (collection) {
            for (JVoiceXmlMainListener listener : this.listeners) {
                listener.jvxmlStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJVoiceXmlTerminated() {
        Collection<JVoiceXmlMainListener> collection = this.listeners;
        synchronized (collection) {
            for (JVoiceXmlMainListener listener : this.listeners) {
                listener.jvxmlTerminated();
            }
        }
    }
}

