/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml;

import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import org.jvoicexml.SpeakableText;
import org.jvoicexml.xml.ssml.Speak;
import org.jvoicexml.xml.ssml.SsmlDocument;
import org.jvoicexml.xml.vxml.BargeInType;

public final class SpeakableSsmlText
implements SpeakableText {
    private static final int HASH_CODE_BASE = 5;
    private static final int HASH_CODE_MULTIPLIER = 59;
    private final SsmlDocument document;
    private long timeout;
    private final BargeInType bargeInType;
    private final boolean bargein;

    public SpeakableSsmlText(String text, Locale locale) throws ParserConfigurationException {
        this.document = new SsmlDocument();
        Speak speak = this.document.getSpeak();
        speak.setXmlLang(locale);
        speak.addText(text);
        this.timeout = -1L;
        this.bargeInType = null;
        this.bargein = true;
    }

    public SpeakableSsmlText(SsmlDocument doc) {
        this.document = doc;
        this.timeout = -1L;
        this.bargeInType = null;
        this.bargein = true;
    }

    public SpeakableSsmlText(SsmlDocument doc, boolean useBargein, BargeInType type) {
        this.document = doc;
        this.timeout = -1L;
        this.bargeInType = type;
        this.bargein = useBargein;
    }

    @Override
    public String getSpeakableText() {
        if (this.document == null) {
            return null;
        }
        return this.document.toString();
    }

    public SsmlDocument getDocument() {
        return this.document;
    }

    @Override
    public SpeakableText appendSpeakableText(String str) {
        if (this.document == null) {
            return this;
        }
        Speak speak = this.document.getSpeak();
        speak.addText(str);
        return this;
    }

    @Override
    public boolean isSpeakableTextEmpty() {
        if (this.document == null) {
            return true;
        }
        Speak speak = this.document.getSpeak();
        return !speak.hasChildNodes();
    }

    @Override
    public boolean isBargeInEnabled(BargeInType type) {
        return this.bargein && (this.bargeInType == null || type == this.bargeInType);
    }

    public BargeInType getBargeInType() {
        return this.bargeInType;
    }

    public long getTimeout() {
        if (this.document == null) {
            return -1L;
        }
        return this.timeout;
    }

    public void setTimeout(long msec) {
        this.timeout = msec;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SpeakableSsmlText)) {
            return false;
        }
        SpeakableSsmlText speakable = (SpeakableSsmlText)other;
        String text = this.getSpeakableText();
        String otherText = speakable.getSpeakableText();
        if (text == null) {
            return otherText == null;
        }
        if (!text.equals(otherText)) {
            return false;
        }
        return this.timeout == speakable.getTimeout();
    }

    public int hashCode() {
        int hash = 5;
        hash *= 59;
        if (this.document != null) {
            hash += this.document.hashCode();
        }
        return (int)((long)(hash *= 59) + this.timeout);
    }

    public String toString() {
        return this.getSpeakableText();
    }
}

