/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.callmanager;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.CallManager;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.JVoiceXml;
import org.jvoicexml.Session;
import org.jvoicexml.callmanager.CallParameters;
import org.jvoicexml.callmanager.ConfiguredApplication;
import org.jvoicexml.callmanager.ConnectionInformationCreationException;
import org.jvoicexml.callmanager.ObservableTerminal;
import org.jvoicexml.callmanager.Terminal;
import org.jvoicexml.callmanager.TerminalConnectionInformationFactory;
import org.jvoicexml.callmanager.TerminalListener;
import org.jvoicexml.event.ErrorEvent;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;

public abstract class BaseCallManager
implements CallManager,
TerminalListener {
    private static final Logger LOGGER = LogManager.getLogger(BaseCallManager.class);
    private TerminalConnectionInformationFactory clientFactory;
    private JVoiceXml jvxml;
    private final Map<String, ConfiguredApplication> applications = new HashMap<String, ConfiguredApplication>();
    private Collection<Terminal> terminals;
    private final Map<Terminal, Session> sessions = new HashMap<Terminal, Session>();

    @Override
    public final void setJVoiceXml(JVoiceXml jvoicexml) {
        this.jvxml = jvoicexml;
    }

    public final JVoiceXml getJVoiceXml() {
        return this.jvxml;
    }

    public final void setConnectionInformationFactory(TerminalConnectionInformationFactory factory) {
        this.clientFactory = factory;
    }

    public final void setApplications(Collection<ConfiguredApplication> apps) {
        for (ConfiguredApplication application : apps) {
            String terminal = application.getTerminal();
            this.addTerminal(terminal, application);
        }
    }

    public final boolean addTerminal(String terminal, ConfiguredApplication application) {
        this.applications.put(terminal, application);
        LOGGER.info("added terminal '" + terminal + "' for application '" + application.getUri() + "'");
        return true;
    }

    public final ConfiguredApplication getApplication(String terminal) {
        return this.applications.get(terminal);
    }

    public final Collection<ConfiguredApplication> getApplications() {
        return this.applications.values();
    }

    @Override
    public final void start() throws NoresourceError, IOException {
        this.terminals = this.createTerminals();
        if (this.terminals == null || this.terminals.isEmpty()) {
            LOGGER.warn("No terminals created. CallManager might work not propertly!");
            return;
        }
        for (Terminal terminal : this.terminals) {
            terminal.waitForConnections();
        }
        LOGGER.info(this.terminals.size() + " terminals created");
        for (Terminal terminal : this.terminals) {
            if (!(terminal instanceof ObservableTerminal)) continue;
            ObservableTerminal observableTerminal = (ObservableTerminal)((Object)terminal);
            observableTerminal.addListener(this);
        }
    }

    protected abstract Collection<Terminal> createTerminals() throws NoresourceError;

    public final Session createSession(Terminal term, CallParameters parameters) throws ErrorEvent {
        ConnectionInformation remote;
        String name = term.getName();
        ConfiguredApplication application = this.applications.get(name);
        if (application == null) {
            throw new BadFetchError("No application defined for terminal '" + name + "'");
        }
        parameters.setTerminal(term);
        try {
            remote = this.clientFactory.createConnectionInformation(this, application, parameters);
        }
        catch (ConnectionInformationCreationException e) {
            throw new NoresourceError(e.getMessage(), e);
        }
        Session session = this.jvxml.createSession(remote);
        URI uri = application.getUriObject();
        session.call(uri);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void terminalConnected(Terminal terminal, CallParameters parameters) {
        try {
            Session session = this.createSession(terminal, parameters);
            Map<Terminal, Session> map = this.sessions;
            synchronized (map) {
                this.sessions.put(terminal, session);
            }
        }
        catch (ErrorEvent e) {
            LOGGER.error("error creating the session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void terminalDisconnected(Terminal terminal) {
        Map<Terminal, Session> map = this.sessions;
        synchronized (map) {
            Session session = this.sessions.get(terminal);
            if (session == null) {
                return;
            }
            session.hangup();
            this.sessions.remove(terminal);
            LOGGER.info("hung up session for terminal '" + terminal.getName() + "'");
        }
    }

    @Override
    public final void terminalError(Terminal terminal, String message, Throwable cause) {
        LOGGER.error("error in terminal '" + terminal.getName() + "': " + message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected(Terminal terminal) {
        Map<Terminal, Session> map = this.sessions;
        synchronized (map) {
            return this.sessions.containsKey(terminal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void hangupSessions() {
        Map<Terminal, Session> map = this.sessions;
        synchronized (map) {
            Set<Terminal> openTerminals = this.sessions.keySet();
            for (Terminal terminal : openTerminals) {
                this.terminalDisconnected(terminal);
            }
        }
    }

    @Override
    public final void stop() {
        this.hangupSessions();
        for (Terminal terminal : this.terminals) {
            terminal.stopWaiting();
        }
        this.handleStop();
    }

    protected void handleStop() {
    }
}

