/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;

public final class ExternalGrammarDocument
implements GrammarDocument {
    private static final Logger LOGGER = LogManager.getLogger(ExternalGrammarDocument.class);
    private static final int HASH_CODE_BASE = 13;
    private static final int HASH_CODE_MULTIPLIER = 31;
    private GrammarType type;
    private ModeType mode;
    private String document;
    private final String charset;
    private final boolean isAscii;
    private final byte[] buffer;
    private URI uri;

    public ExternalGrammarDocument(URI source, byte[] content, String encoding, boolean ascii) {
        this.uri = source;
        this.charset = encoding;
        this.isAscii = ascii;
        this.document = null;
        this.buffer = content;
    }

    @Override
    public boolean isCacheable() {
        return false;
    }

    @Override
    public void setURI(URI value) {
        this.uri = value;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public GrammarType getMediaType() {
        return this.type;
    }

    @Override
    public void setMediaType(GrammarType grammartype) {
        this.type = grammartype;
    }

    @Override
    public boolean isAscii() {
        return this.isAscii;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public String getDocument() {
        if (this.document == null && this.buffer != null) {
            if (this.charset == null) {
                this.document = new String(this.buffer);
            } else {
                try {
                    this.document = new String(this.buffer, this.charset);
                }
                catch (UnsupportedEncodingException ex) {
                    LOGGER.warn("unable to use charset '" + this.charset + "' to convert grammar '" + this.uri + "'' Using default.", (Throwable)ex);
                    this.document = new String(this.buffer);
                }
            }
        }
        return this.document;
    }

    @Override
    public String getTextContent() {
        return this.getDocument();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GrammarDocument)) {
            return false;
        }
        GrammarDocument other = (GrammarDocument)obj;
        return this.equals(other);
    }

    @Override
    public boolean equals(GrammarDocument other) {
        byte[] otherBuffer = other.getBuffer();
        return Arrays.equals(this.buffer, otherBuffer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 13;
        result = 31 * result + Arrays.hashCode(this.buffer);
        return result;
    }

    @Override
    public ModeType getModeType() {
        return this.mode;
    }

    @Override
    public void setModeType(ModeType modeType) {
        this.mode = modeType;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getCanonicalName());
        str.append('[');
        str.append(this.uri);
        str.append(',');
        str.append(this.mode);
        str.append(',');
        str.append(this.type);
        str.append(',');
        str.append(this.charset);
        str.append(',');
        str.append(this.getDocument());
        str.append(']');
        return str.toString();
    }
}

