/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.DocumentDescriptor;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.FetchAttributes;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.documentserver.ExternalGrammarDocument;
import org.jvoicexml.documentserver.ExternalReferenceGrammarDocument;
import org.jvoicexml.documentserver.ReadBuffer;
import org.jvoicexml.documentserver.SchemeStrategy;
import org.jvoicexml.documentserver.jetty.DocumentStorage;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.UnsupportedElementError;
import org.jvoicexml.interpreter.datamodel.KeyValuePair;
import org.jvoicexml.xml.vxml.RequestMethod;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;
import org.jvoicexml.xml.vxml.Vxml;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class JVoiceXmlDocumentServer
implements DocumentServer {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlDocumentServer.class);
    private final Map<String, SchemeStrategy> strategies = new HashMap<String, SchemeStrategy>();
    private FetchAttributes attributes;
    private DocumentStorage storage;

    public void setDocumentStorage(DocumentStorage documentStorage) {
        this.storage = documentStorage;
    }

    @Override
    public void start() throws Exception {
        this.storage.start();
    }

    public void setSchemeStrategies(List<SchemeStrategy> schemeStrategies) {
        for (SchemeStrategy strategy : schemeStrategies) {
            this.addSchemeStrategy(strategy);
        }
    }

    public void setFetchAttributes(FetchAttributes attrs) {
        this.attributes = attrs;
        LOGGER.info("default fetch timeout: " + this.attributes.getFetchTimeout() + "msec");
    }

    private FetchAttributes mergeFetchAttributes(FetchAttributes attrs) {
        long maxStale;
        long maxAge;
        long fetchTimeout;
        String fetchHint;
        if (this.attributes == null) {
            if (attrs == null) {
                return new FetchAttributes();
            }
            return attrs;
        }
        if (attrs == null) {
            return this.attributes;
        }
        FetchAttributes merge = new FetchAttributes(this.attributes);
        URI fetchAudio = attrs.getFetchAudio();
        if (fetchAudio != null) {
            merge.setFetchAudio(fetchAudio);
        }
        if ((fetchHint = attrs.getFetchHint()) != null) {
            merge.setFetchHint(fetchHint);
        }
        if ((fetchTimeout = attrs.getFetchTimeout()) > 0L) {
            merge.setFetchTimeout(fetchTimeout);
        }
        if ((maxAge = attrs.getMaxage()) > 0L) {
            merge.setMaxage(maxAge);
        }
        if ((maxStale = attrs.getMaxstale()) > 0L) {
            merge.setMaxage(maxStale);
        }
        return merge;
    }

    private VoiceXmlDocument readDocument(InputStream input) throws BadFetchError {
        InputSource inputSource = new InputSource(input);
        try {
            return new VoiceXmlDocument(inputSource);
        }
        catch (ParserConfigurationException pce) {
            throw new BadFetchError(pce);
        }
        catch (SAXException saxe) {
            throw new BadFetchError(saxe);
        }
        catch (IOException ioe) {
            throw new BadFetchError(ioe);
        }
    }

    @Override
    public VoiceXmlDocument getDocument(String sessionId, DocumentDescriptor descriptor) throws BadFetchError {
        Vxml vxml;
        String version;
        VoiceXmlDocument document;
        URI uri = descriptor.getUri();
        SchemeStrategy strategy = this.getSchemeStrategy(uri);
        RequestMethod method = descriptor.getMethod();
        Collection<KeyValuePair> parameters = descriptor.getParameters();
        FetchAttributes attrs = descriptor.getAttributes();
        FetchAttributes mergedAttrs = this.mergeFetchAttributes(attrs);
        long timeout = mergedAttrs.getFetchTimeout();
        LOGGER.info("loading document with URI '" + uri + "...");
        InputStream input = null;
        try {
            input = strategy.getInputStream(sessionId, uri, method, timeout, parameters);
            document = this.readDocument(input);
        }
        catch (UnsupportedElementError e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    throw new BadFetchError(e);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...read document");
            LOGGER.debug((Object)document);
        }
        if ((version = (vxml = document.getVxml()).getVersion()) == null) {
            throw new BadFetchError("The document at '" + uri + "' does not provide a version attribute!");
        }
        return document;
    }

    private SchemeStrategy getSchemeStrategy(URI uri) throws BadFetchError {
        if (uri == null) {
            throw new BadFetchError("Cannot get a strategy for a null URI!");
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new BadFetchError("Unable to find scheme in '" + uri + "'!");
        }
        SchemeStrategy strategy = this.strategies.get(scheme);
        if (strategy == null) {
            throw new BadFetchError("no strategy for scheme '" + scheme + "'!");
        }
        return strategy;
    }

    public void addSchemeStrategy(SchemeStrategy strategy) {
        if (strategy == null) {
            LOGGER.warn("cannot add null scheme strategy");
            return;
        }
        String scheme = strategy.getScheme();
        LOGGER.info("adding scheme strategy for scheme '" + scheme + "': " + strategy.getClass().getName());
        this.strategies.put(strategy.getScheme(), strategy);
    }

    @Override
    public URI resolveBuiltinUri(URI uri) {
        return this.storage.resolveBuiltinUri(uri);
    }

    @Override
    public URI addGrammarDocument(String sessionId, GrammarDocument document) throws URISyntaxException {
        return this.storage.addGrammarDocument(sessionId, document);
    }

    @Override
    public GrammarDocument getGrammarDocument(String sessionId, URI uri, FetchAttributes attrs) throws BadFetchError {
        if (attrs.isFetchintSafe()) {
            LOGGER.debug("not loading a fetchhint safe grammar");
            return new ExternalReferenceGrammarDocument(uri);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("retrieving grammar '" + uri + "'");
        }
        DocumentDescriptor descriptor = new DocumentDescriptor(uri);
        ReadBuffer buffer = (ReadBuffer)this.getObject(sessionId, descriptor, null);
        byte[] bytes = buffer.getBytes();
        String encoding = buffer.getCharset();
        boolean ascii = buffer.isAscii();
        return new ExternalGrammarDocument(uri, bytes, encoding, ascii);
    }

    @Override
    public AudioInputStream getAudioInputStream(String sessionId, URI uri) throws BadFetchError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("retrieving audio input stream '" + uri + "'");
        }
        SchemeStrategy strategy = this.getSchemeStrategy(uri);
        FetchAttributes attrs = this.mergeFetchAttributes(null);
        long timeout = attrs.getFetchTimeout();
        try {
            InputStream input = strategy.getInputStream(sessionId, uri, RequestMethod.GET, timeout, null);
            BufferedInputStream buf = new BufferedInputStream(input);
            return AudioSystem.getAudioInputStream(buf);
        }
        catch (UnsupportedAudioFileException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        catch (UnsupportedElementError e) {
            throw new BadFetchError(e.getMessage(), e);
        }
    }

    @Override
    public Object getObject(String sessionId, DocumentDescriptor descriptor, String type) throws BadFetchError {
        Document object;
        block20: {
            URI uri = descriptor.getUri();
            LOGGER.info("retrieving object with type '" + type + "' from '" + uri + "'");
            RequestMethod method = descriptor.getMethod();
            Collection<KeyValuePair> parameters = descriptor.getParameters();
            FetchAttributes attrs = descriptor.getAttributes();
            FetchAttributes mergedAttrs = this.mergeFetchAttributes(attrs);
            long timeout = mergedAttrs.getFetchTimeout();
            SchemeStrategy strategy = this.getSchemeStrategy(uri);
            InputStream input = null;
            try {
                input = strategy.getInputStream(sessionId, uri, method, timeout, parameters);
                if (type == null) {
                    ReadBuffer buffer = new ReadBuffer();
                    buffer.read(input);
                    ReadBuffer readBuffer = buffer;
                    return readBuffer;
                }
                if (type.equals("text/plain")) {
                    ReadBuffer buffer = new ReadBuffer();
                    buffer.read(input);
                    String string = buffer.toString();
                    return string;
                }
                if (type.equals("text/xml")) {
                    object = this.readXml(input);
                    break block20;
                }
                throw new BadFetchError("unknown type '" + type + "'");
            }
            catch (IOException e) {
                throw new BadFetchError(e.getMessage(), e);
            }
            catch (UnsupportedElementError e) {
                throw new BadFetchError(e.getMessage(), e);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        throw new BadFetchError(e);
                    }
                }
            }
        }
        return object;
    }

    private Document readXml(InputStream in) throws BadFetchError {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource source = new InputSource(in);
            return builder.parse(source);
        }
        catch (ParserConfigurationException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
    }

    @Override
    public URI storeAudio(AudioInputStream in) throws BadFetchError {
        try {
            File directory = this.getRecordingsDirectory();
            File file = File.createTempFile("rec-", ".wav", directory);
            AudioSystem.write(in, AudioFileFormat.Type.WAVE, file);
            LOGGER.info("recorded to file '" + file.toURI() + "'");
            return file.toURI();
        }
        catch (IOException ex) {
            throw new BadFetchError(ex.getMessage(), ex);
        }
    }

    private File getRecordingsDirectory() {
        File directory = new File("work/recordings/");
        if (!directory.exists()) {
            LOGGER.info("created recordings directory '" + directory.toURI() + "'");
            directory.mkdirs();
        }
        return directory;
    }

    @Override
    public void sessionClosed(String sessionId) {
        Collection<SchemeStrategy> knownStrategies = this.strategies.values();
        for (SchemeStrategy strategy : knownStrategies) {
            strategy.sessionClosed(sessionId);
        }
        try {
            this.storage.clear(sessionId);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("error clearing session", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.storage.stop();
        }
        catch (Exception e) {
            LOGGER.warn("error closing the document storage", (Throwable)e);
        }
    }
}

