/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.documentserver.JVoiceXmlCharsetDetectionObserver;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class ReadBuffer {
    private static final Logger LOGGER = LogManager.getLogger(ReadBuffer.class);
    private static final int READ_BUFFER_SIZE = 1024;
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private boolean isAscii = true;
    private String charset;

    public void read(InputStream input) throws IOException {
        int num;
        nsDetector detector = new nsDetector();
        JVoiceXmlCharsetDetectionObserver observer = new JVoiceXmlCharsetDetectionObserver();
        detector.Init((nsICharsetDetectionObserver)observer);
        boolean done = false;
        byte[] readBuffer = new byte[1024];
        do {
            if ((num = input.read(readBuffer)) < 0) continue;
            this.buffer.write(readBuffer, 0, num);
            if (this.isAscii) {
                this.isAscii = detector.isAscii(readBuffer, num);
            }
            if (this.isAscii || done) continue;
            done = detector.DoIt(readBuffer, num, false);
        } while (num >= 0);
        detector.DataEnd();
        this.charset = observer.getCharset();
        if (this.charset != null && LOGGER.isDebugEnabled()) {
            LOGGER.debug("detected charset '" + this.charset + "'");
        }
    }

    public boolean isAscii() {
        return this.isAscii;
    }

    public String getCharset() {
        return this.charset;
    }

    public byte[] getBytes() {
        return this.buffer.toByteArray();
    }

    public InputStream getInputStream() {
        byte[] bytes = this.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    public String toString() {
        byte[] bytes = this.getBytes();
        if (this.isAscii) {
            if (this.charset == null) {
                return new String(bytes);
            }
            try {
                return new String(bytes, this.charset);
            }
            catch (UnsupportedEncodingException e) {
                return super.toString();
            }
        }
        return super.toString();
    }
}

