/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VariableEncoder {
    private static final Logger LOGGER = LogManager.getLogger(VariableEncoder.class);
    private final URI base;
    private final Map<String, String> variables;
    private final String encoding;

    public VariableEncoder(URI uri) {
        this.base = this.getBaseUri(uri);
        this.variables = this.getVariables(uri);
        this.encoding = System.getProperty("jvoicexml.xml.encoding", "UTF-8");
    }

    private URI getBaseUri(URI uri) {
        String str = uri.toString();
        int queryPos = str.indexOf(63);
        if (queryPos < 0) {
            return uri;
        }
        try {
            return new URI(str.substring(0, queryPos));
        }
        catch (URISyntaxException use) {
            LOGGER.error("Unable to extract base uri", (Throwable)use);
            return uri;
        }
    }

    private Map<String, String> getVariables(URI uri) {
        HashMap<String, String> vars = new HashMap<String, String>();
        String str = uri.toString();
        int queryPos = str.indexOf(63);
        if (queryPos < 0) {
            return vars;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, "&=");
        while (tokenizer.hasMoreTokens()) {
            String value;
            String name = tokenizer.nextToken();
            if (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                try {
                    value = URLDecoder.decode(token, this.encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    LOGGER.warn("unable to decode '" + token + "'", (Throwable)ex);
                    value = token;
                }
            } else {
                value = "";
            }
            vars.put(name, value);
        }
        return vars;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void add(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.variables.put(name, value);
    }

    public URI toUri() {
        if (this.variables.isEmpty()) {
            return this.base;
        }
        StringBuilder str = new StringBuilder();
        str.append(this.base.toString());
        str.append('?');
        Iterator<String> iterator = this.variables.keySet().iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            str.append(name);
            str.append('=');
            String value = this.variables.get(name);
            try {
                str.append(URLEncoder.encode(value, this.encoding));
            }
            catch (UnsupportedEncodingException ex) {
                LOGGER.warn("unable to encode '" + value + "'", (Throwable)ex);
                str.append(value);
            }
            if (!iterator.hasNext()) continue;
            str.append('&');
        }
        try {
            return new URI(str.toString());
        }
        catch (URISyntaxException use) {
            LOGGER.error("unable to create uri", (Throwable)use);
            return null;
        }
    }

    public URI getBaseUri() {
        return this.base;
    }
}

