/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.jetty;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jvoicexml.documentserver.schemestrategy.builtin.GrammarCreator;
import org.jvoicexml.event.error.BadFetchError;

public class BuiltinGrammarHandler
extends AbstractHandler {
    private static final Logger LOGGER = LogManager.getLogger(BuiltinGrammarHandler.class);
    public static String CONTEXT_PATH = "/builtin";
    private final Map<String, GrammarCreator> creators = new HashMap<String, GrammarCreator>();

    public void setGrammarCreators(Collection<GrammarCreator> col) {
        for (GrammarCreator creator : col) {
            this.addGrammarCreator(creator);
        }
    }

    public void addGrammarCreator(GrammarCreator creator) {
        String type = creator.getTypeName();
        this.creators.put(type, creator);
        LOGGER.info("added builtin grammar creator '" + creator.getClass() + "' for type '" + type + "'");
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.info("request from " + request.getRemoteAddr() + " to builtin grammar handler");
        String requestUri = request.getRequestURI();
        String builtintUri = requestUri.substring(CONTEXT_PATH.length() + 1);
        String type = this.extractBuiltinType(builtintUri);
        GrammarCreator creator = this.creators.get(type);
        if (creator == null) {
            LOGGER.warn("builtin type '" + type + "' is not supported!");
            response.setStatus(404);
            return;
        }
        try {
            URI uri = new URI("builtin:" + builtintUri);
            byte[] bytes = creator.createGrammar(uri);
            ServletOutputStream out = response.getOutputStream();
            out.write(bytes);
            baseRequest.setHandled(true);
            response.setStatus(200);
        }
        catch (URISyntaxException | BadFetchError e) {
            LOGGER.warn("invalid uri '" + builtintUri + "'");
            response.setStatus(400);
        }
    }

    private String extractBuiltinType(String requestUri) {
        String[] path = requestUri.split("/");
        String type = path[1];
        int pos = type.indexOf(63);
        if (pos >= 0) {
            type = type.substring(0, pos);
        }
        return type.toLowerCase();
    }
}

