/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.jetty;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.documentserver.jetty.BuiltinGrammarHandler;
import org.jvoicexml.documentserver.jetty.InternalGrammarDocumentHandler;
import org.jvoicexml.documentserver.schemestrategy.builtin.GrammarCreator;

public class DocumentStorage {
    private static final Logger LOGGER = LogManager.getLogger(DocumentStorage.class);
    private final Map<String, Collection<GrammarDocument>> sessionDocuments = new HashMap<String, Collection<GrammarDocument>>();
    private final Map<URI, GrammarDocument> documents = new HashMap<URI, GrammarDocument>();
    private Server server;
    private int storagePort = 9595;
    private final Handler internalGrammarHandler = new InternalGrammarDocumentHandler(this);
    private final BuiltinGrammarHandler builtinGrammarHandler = new BuiltinGrammarHandler();

    public void setStoragePort(int port) {
        this.storagePort = port;
    }

    public void setGrammarCreators(Collection<GrammarCreator> col) {
        this.builtinGrammarHandler.setGrammarCreators(col);
    }

    public void start() throws Exception {
        if (this.storagePort < 0) {
            return;
        }
        this.server = new Server(this.storagePort);
        ContextHandler rootContext = new ContextHandler();
        rootContext.setHandler(this.internalGrammarHandler);
        ContextHandler internalGrammarContext = new ContextHandler(InternalGrammarDocumentHandler.CONTEXT_PATH);
        internalGrammarContext.setHandler(this.internalGrammarHandler);
        ContextHandler builtinGrammarContext = new ContextHandler(BuiltinGrammarHandler.CONTEXT_PATH);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        builtinGrammarContext.setHandler((Handler)this.builtinGrammarHandler);
        ContextHandler[] handlers = new ContextHandler[]{rootContext, internalGrammarContext, builtinGrammarContext};
        contexts.setHandlers((Handler[])handlers);
        this.server.setHandler((Handler)contexts);
        this.server.start();
        LOGGER.info("document storage started on port " + this.storagePort);
    }

    public URI resolveBuiltinUri(URI uri) {
        URI serverUri = this.server.getURI();
        try {
            return new URI(serverUri + BuiltinGrammarHandler.CONTEXT_PATH.substring(1) + "/" + uri.getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            LOGGER.warn("unable to resolve '" + uri + "'");
            return uri;
        }
    }

    public URI addGrammarDocument(String sessionId, GrammarDocument document) throws URISyntaxException {
        Collection<GrammarDocument> currentDocuments = this.getCurrentSessionDocuments(sessionId);
        currentDocuments.add(document);
        URI localUri = new URI(InternalGrammarDocumentHandler.CONTEXT_PATH + "/" + sessionId + "/" + document.hashCode());
        this.documents.put(localUri, document);
        URI serverUri = this.server.getURI();
        URI uri = new URI(serverUri + InternalGrammarDocumentHandler.CONTEXT_PATH.substring(1) + "/" + sessionId + "/" + document.hashCode());
        document.setURI(uri);
        LOGGER.info("added grammar document at '" + uri + "'");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("added document " + document);
        }
        return null;
    }

    private Collection<GrammarDocument> getCurrentSessionDocuments(String sessionId) {
        Collection<GrammarDocument> currentDocuments = this.sessionDocuments.get(sessionId);
        if (currentDocuments != null) {
            return currentDocuments;
        }
        currentDocuments = new ArrayList<GrammarDocument>();
        this.sessionDocuments.put(sessionId, currentDocuments);
        LOGGER.info("initialized document storage for session '" + sessionId + "'");
        return currentDocuments;
    }

    public GrammarDocument getDocument(URI uri) throws URISyntaxException {
        String path = uri.getPath();
        URI pathUri = new URI(path);
        return this.documents.get(pathUri);
    }

    public void clear(String sessionId) throws URISyntaxException {
        Collection<GrammarDocument> currentDocuments = this.sessionDocuments.get(sessionId);
        if (currentDocuments == null) {
            LOGGER.warn("session '" + sessionId + "' unknown. cannot clear");
            return;
        }
        for (GrammarDocument document : currentDocuments) {
            URI uri = document.getURI();
            String path = uri.getPath();
            URI pathUri = new URI(path);
            this.documents.remove(pathUri);
        }
        this.sessionDocuments.remove(sessionId);
        LOGGER.info("cleared document storage for session '" + sessionId + "'");
    }

    public void stop() throws Exception {
        if (this.storagePort < 0) {
            return;
        }
        this.server.stop();
        LOGGER.info("document storage stopped");
    }
}

