/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.jetty;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.documentserver.jetty.DocumentStorage;
import org.jvoicexml.xml.srgs.GrammarType;

class InternalGrammarDocumentHandler
extends AbstractHandler {
    private static final Logger LOGGER = LogManager.getLogger(InternalGrammarDocumentHandler.class);
    public static String CONTEXT_PATH = "/grammars";
    private final DocumentStorage storage;

    public InternalGrammarDocumentHandler(DocumentStorage documentStorage) {
        this.storage = documentStorage;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.info("request from " + request.getRemoteAddr() + " to internal grammar handler");
        String requestUri = request.getRequestURI();
        try {
            byte[] buffer;
            URI uri = new URI(requestUri);
            GrammarDocument document = this.storage.getDocument(uri);
            if (document == null) {
                LOGGER.warn("no document with URI '" + uri + "'");
                response.setStatus(404);
                return;
            }
            GrammarType type = document.getMediaType();
            String contentType = this.getContentType(type);
            if (contentType != null) {
                response.setContentType(contentType);
            }
            if ((buffer = document.getBuffer()) == null) {
                LOGGER.warn("no document found at '" + uri + "'");
                response.setStatus(404);
            }
            ServletOutputStream out = response.getOutputStream();
            out.write(buffer);
            baseRequest.setHandled(true);
            response.setStatus(200);
        }
        catch (URISyntaxException e) {
            LOGGER.warn("unabale to create request uri '" + requestUri + "'", (Throwable)e);
            response.setStatus(400);
        }
    }

    private String getContentType(GrammarType type) {
        if (type == GrammarType.SRGS_XML) {
            return "text/xml";
        }
        if (type == GrammarType.SRGS_ABNF) {
            return "text/plain";
        }
        if (type == GrammarType.GSL) {
            return "text/plain";
        }
        return null;
    }
}

