/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.documentserver.schemestrategy.MappedDocumentRepository;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.xml.vxml.VoiceXmlDocument;

public final class DocumentMap
implements MappedDocumentRepository {
    private static final Logger LOGGER = LogManager.getLogger(DocumentMap.class);
    private static final DocumentMap REPOSITORY = new DocumentMap();
    private final Map<URI, String> documents = new Hashtable<URI, String>();

    private DocumentMap() {
    }

    public static DocumentMap getInstance() {
        return REPOSITORY;
    }

    @Override
    public URI getUri(String path) throws URISyntaxException {
        return new URI("jvxmlmap", null, path, null);
    }

    @Override
    public void addDocument(URI uri, String document) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("adding document with URI '" + uri + "'");
            LOGGER.debug(document);
        }
        this.documents.put(uri, document);
    }

    @Override
    public void addDocument(URI uri, VoiceXmlDocument document) {
        this.addDocument(uri, document.toString());
    }

    public String getDocument(URI uri) throws BadFetchError {
        String document;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getting document with URI '" + uri + "'");
        }
        if ((document = this.documents.get(uri)) == null) {
            throw new BadFetchError("No document with URI '" + uri + "'!");
        }
        return document;
    }
}

