/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.documentserver.SchemeStrategy;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.interpreter.datamodel.KeyValuePair;
import org.jvoicexml.xml.vxml.RequestMethod;

public final class FileSchemeStrategy
implements SchemeStrategy {
    private static final Logger LOGGER = LogManager.getLogger(FileSchemeStrategy.class);
    public static final String SCHEME_NAME = "file";

    @Override
    public String getScheme() {
        return SCHEME_NAME;
    }

    @Override
    public InputStream getInputStream(String sessionId, URI uri, RequestMethod method, long timeout, Collection<KeyValuePair> parameters) throws BadFetchError {
        try {
            String scheme = uri.getScheme();
            String path = uri.getPath();
            URI fragmentLessUri = new URI(scheme, null, path, null);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("reading '" + fragmentLessUri + "'...");
            }
            File file = new File(fragmentLessUri);
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
    }

    @Override
    public void sessionClosed(String sessionId) {
    }
}

