/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.documentserver.ReadBuffer;
import org.jvoicexml.documentserver.SchemeStrategy;
import org.jvoicexml.documentserver.schemestrategy.HttpClientSessionIdentifierFactory;
import org.jvoicexml.documentserver.schemestrategy.SessionStorage;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.SemanticError;
import org.jvoicexml.interpreter.datamodel.KeyValuePair;
import org.jvoicexml.xml.vxml.RequestMethod;

public final class HttpSchemeStrategy
implements SchemeStrategy {
    private static final Logger LOGGER = LogManager.getLogger(HttpSchemeStrategy.class);
    public static final String HTTP_SCHEME_NAME = "http";
    protected static SessionStorage<HttpClientBuilder> SESSION_STORAGE;
    private String scheme = "http";
    private int defaultFetchTimeout;

    public void setScheme(String value) {
        this.scheme = value;
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    public void setFetchTimeout(int timeout) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("default fetch timeout: " + timeout);
        }
        this.defaultFetchTimeout = timeout;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getInputStream(String sessionId, URI uri, RequestMethod method, long timeout, Collection<KeyValuePair> parameters) throws BadFetchError {
        HttpClientBuilder builder = SESSION_STORAGE.getSessionIdentifier(sessionId);
        RequestConfig config = this.setTimeout(timeout);
        try (CloseableHttpClient client = builder.setDefaultRequestConfig(config).build();){
            String fragmentLessUriString = StringUtils.substringBeforeLast((String)uri.toString(), (String)"#");
            URI fragmentLessUri = new URI(fragmentLessUriString);
            URI requestUri = this.addParameters(parameters, fragmentLessUri);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("connecting to '" + requestUri + "'...");
            }
            Object request = method == RequestMethod.GET ? new HttpGet(requestUri) : new HttpPost(requestUri);
            this.attachFiles((HttpUriRequest)request, parameters);
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            int status = statusLine.getStatusCode();
            if (status != 200) {
                String reasonPhrase = statusLine.getReasonPhrase();
                LOGGER.error("error accessing '" + uri + "': " + reasonPhrase + " (HTTP error code " + status + ")");
                InputStream inputStream = null;
                return inputStream;
            }
            HttpEntity entity = response.getEntity();
            InputStream input = entity.getContent();
            ReadBuffer buffer = new ReadBuffer();
            buffer.read(input);
            InputStream inputStream = buffer.getInputStream();
            return inputStream;
        }
        catch (IOException | URISyntaxException | ParseException | SemanticError e) {
            throw new BadFetchError(e.getMessage(), e);
        }
    }

    private RequestConfig setTimeout(long timeout) {
        int usedTimeout;
        if (timeout != 0L) {
            usedTimeout = (int)timeout;
        } else if (this.defaultFetchTimeout != 0) {
            usedTimeout = this.defaultFetchTimeout;
        } else {
            return RequestConfig.custom().build();
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(usedTimeout * 1000).setConnectionRequestTimeout((int)(timeout * 1000L)).setSocketTimeout((int)(timeout * 1000L)).build();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("timeout set to '" + timeout + "'");
        }
        return config;
    }

    private URI addParameters(Collection<KeyValuePair> parameters, URI uri) throws URISyntaxException, SemanticError {
        if (parameters == null || parameters.isEmpty()) {
            return uri;
        }
        URIBuilder builder = new URIBuilder(uri);
        for (KeyValuePair current : parameters) {
            Object value = current.getValue();
            if (value instanceof File) continue;
            String name = current.getKey();
            builder.addParameter(name, value.toString());
        }
        return builder.build();
    }

    private void attachFiles(HttpUriRequest request, Collection<KeyValuePair> parameters) {
        if (!(request instanceof HttpPost)) {
            return;
        }
        HttpPost post = (HttpPost)request;
        for (KeyValuePair current : parameters) {
            Object value = current.getValue();
            if (!(value instanceof File)) continue;
            File file = (File)value;
            FileEntity fileEntity = new FileEntity(file, ContentType.create((String)"binary/octet-stream"));
            post.setEntity((HttpEntity)fileEntity);
        }
    }

    @Override
    public void sessionClosed(String sessionId) {
        SESSION_STORAGE.releaseSession(sessionId);
    }

    static {
        HttpClientSessionIdentifierFactory factory = new HttpClientSessionIdentifierFactory();
        SESSION_STORAGE = new SessionStorage<HttpClientBuilder>(factory);
    }
}

