/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.jvoicexml.documentserver.SchemeStrategy;
import org.jvoicexml.documentserver.schemestrategy.DocumentMap;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.interpreter.datamodel.KeyValuePair;
import org.jvoicexml.xml.vxml.RequestMethod;

public final class MappedDocumentStrategy
implements SchemeStrategy {
    public static final String SCHEME_NAME = "jvxmlmap";

    @Override
    public String getScheme() {
        return SCHEME_NAME;
    }

    @Override
    public InputStream getInputStream(String sessionId, URI uri, RequestMethod method, long timeout, Collection<KeyValuePair> parameters) throws BadFetchError {
        URI fragmentLessUri;
        if (uri == null) {
            throw new BadFetchError("Unable to retrieve a document for null!");
        }
        DocumentMap repository = DocumentMap.getInstance();
        String scheme = uri.getScheme();
        String path = uri.getPath();
        try {
            fragmentLessUri = new URI(scheme, null, path, null);
        }
        catch (URISyntaxException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        String document = repository.getDocument(fragmentLessUri);
        if (document == null) {
            return null;
        }
        String encoding = this.getEncoding(document);
        if (encoding == null) {
            encoding = System.getProperty("jvoicexml.xml.encoding", "UTF-8");
        }
        try {
            return new ByteArrayInputStream(document.getBytes(encoding));
        }
        catch (IOException ioe) {
            throw new BadFetchError(ioe);
        }
    }

    private String getEncoding(String document) {
        if (document.startsWith("<?xml")) {
            return null;
        }
        int encStart = document.indexOf("encoding");
        if (encStart < 0) {
            return null;
        }
        int encValueStart = document.indexOf(34, encStart);
        int encValueEnd = document.indexOf(34, encValueStart + 1);
        return document.substring(encValueStart + 1, encValueEnd);
    }

    @Override
    public void sessionClosed(String sessionId) {
    }
}

