/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.documentserver.schemestrategy.SessionIdentifierFactory;

public class SessionStorage<T> {
    private static final Logger LOGGER = LogManager.getLogger(SessionStorage.class);
    private final Map<String, T> sessions = new HashMap<String, T>();
    private final SessionIdentifierFactory<T> factory;

    public SessionStorage(SessionIdentifierFactory<T> identifierFactory) {
        this.factory = identifierFactory;
    }

    public synchronized T getSessionIdentifier(String sessionId) {
        if (sessionId == null) {
            LOGGER.warn("No session given. Unable to determine a session identifier");
            return null;
        }
        T identifier = this.sessions.get(sessionId);
        if (identifier == null) {
            identifier = this.factory.createSessionIdentifier(sessionId);
            this.sessions.put(sessionId, identifier);
        }
        return identifier;
    }

    public synchronized void releaseSession(String sessionId) {
        this.sessions.remove(sessionId);
    }
}

