/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy.builtin;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.jvoicexml.documentserver.schemestrategy.builtin.GrammarCreator;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.srgs.SrgsXmlDocument;

public abstract class AbstractGrammarCreator
implements GrammarCreator {
    public final byte[] getBytes(SrgsXmlDocument document) throws IOException {
        String xml = document.toXml();
        return xml.getBytes();
    }

    protected final ModeType getMode(URI uri) throws BadFetchError {
        ModeType mode;
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        String[] path = schemeSpecificPart.split("/");
        String modeSpecifier = path[0];
        try {
            String str = modeSpecifier.toUpperCase();
            if (str.equals("GRAMMAR")) {
                return ModeType.VOICE;
            }
            mode = ModeType.valueOf((String)str);
        }
        catch (IllegalArgumentException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        return mode;
    }

    protected final Map<String, String> getParameters(URI uri) throws BadFetchError {
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        int pos = schemeSpecificPart.indexOf(63);
        if (pos < 0) {
            return new HashMap<String, String>();
        }
        String query = schemeSpecificPart.substring(pos + 1);
        String[] pairs = query.split(";");
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairs) {
            String[] current = pair.split("=");
            if (current.length != 2) {
                throw new BadFetchError("Error parsing the parameters from '" + uri + "'!");
            }
            String key = current[0];
            String value = current[1];
            parameters.put(key, value);
        }
        return parameters;
    }
}

