/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy.builtin;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.jvoicexml.documentserver.schemestrategy.builtin.AbstractGrammarCreator;
import org.jvoicexml.documentserver.schemestrategy.builtin.GrammarCreator;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.Item;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.srgs.OneOf;
import org.jvoicexml.xml.srgs.Rule;
import org.jvoicexml.xml.srgs.SrgsXmlDocument;
import org.jvoicexml.xml.srgs.Tag;

public class BooleanGrammarCreator
extends AbstractGrammarCreator
implements GrammarCreator {
    private static final String NO_PARAMETER_NAME = "n";
    private static final String YES_PARAMETER_NAME = "y";
    public static final String TYPE_NAME = "boolean";

    @Override
    public byte[] createGrammar(URI uri) throws BadFetchError, IOException {
        Map<String, String> parameters = this.getParameters(uri);
        ModeType mode = this.getMode(uri);
        if (mode == ModeType.VOICE) {
            parameters.put(YES_PARAMETER_NAME, "yes");
        } else if (!parameters.containsKey(YES_PARAMETER_NAME)) {
            parameters.put(YES_PARAMETER_NAME, "1");
        }
        if (mode == ModeType.VOICE) {
            parameters.put(NO_PARAMETER_NAME, "no");
        } else if (!parameters.containsKey(NO_PARAMETER_NAME)) {
            parameters.put(NO_PARAMETER_NAME, "2");
        }
        SrgsXmlDocument document = this.createGrammar(parameters, mode);
        return this.getBytes(document);
    }

    private SrgsXmlDocument createGrammar(Map<String, String> parameters, ModeType mode) throws BadFetchError {
        SrgsXmlDocument document;
        try {
            document = new SrgsXmlDocument();
        }
        catch (ParserConfigurationException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        Grammar grammar = document.getGrammar();
        grammar.setMode(mode);
        if (mode == ModeType.VOICE) {
            grammar.setAttribute("xml:lang", "en");
        }
        grammar.setType(GrammarType.SRGS_XML);
        grammar.setVersion("1.0");
        grammar.setAttribute("xmlns", "http://www.w3.org/2001/06/grammar");
        grammar.setAttribute("tag-format", "semantics/1.0-literals");
        Rule rule = (Rule)grammar.appendChild(Rule.class);
        rule.makePublic();
        rule.setId(TYPE_NAME);
        grammar.setRoot(rule);
        OneOf oneof = (OneOf)rule.appendChild(OneOf.class);
        Item yes = (Item)oneof.appendChild(Item.class);
        yes.addText(parameters.get(YES_PARAMETER_NAME));
        Tag yesTag = (Tag)yes.appendChild(Tag.class);
        yesTag.addText("true");
        Item no = (Item)oneof.appendChild(Item.class);
        no.addText(parameters.get(NO_PARAMETER_NAME));
        Tag noTag = (Tag)no.appendChild(Tag.class);
        noTag.addText("false");
        return document;
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }
}

