/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy.builtin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.documentserver.SchemeStrategy;
import org.jvoicexml.documentserver.schemestrategy.builtin.GrammarCreator;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.UnsupportedBuiltinError;
import org.jvoicexml.event.error.UnsupportedElementError;
import org.jvoicexml.interpreter.datamodel.KeyValuePair;
import org.jvoicexml.xml.vxml.RequestMethod;

public final class BuiltinSchemeStrategy
implements SchemeStrategy {
    private static final Logger LOGGER = LogManager.getLogger(BuiltinSchemeStrategy.class);
    public static final String SCHEME_NAME = "builtin";
    private final Map<String, GrammarCreator> creators = new HashMap<String, GrammarCreator>();

    public void setGrammarCreators(Collection<GrammarCreator> col) {
        for (GrammarCreator creator : col) {
            this.addGrammarCreator(creator);
        }
    }

    public void addGrammarCreator(GrammarCreator creator) {
        String type = creator.getTypeName();
        this.creators.put(type, creator);
        LOGGER.info("added builtin grammar creator '" + creator.getClass() + "' for type '" + type + "'");
    }

    @Override
    public InputStream getInputStream(String sessionId, URI uri, RequestMethod method, long timeout, Collection<KeyValuePair> parameters) throws BadFetchError, UnsupportedElementError, IOException {
        String type = this.extractBuiltinType(uri);
        GrammarCreator creator = this.creators.get(type);
        if (creator == null) {
            throw new UnsupportedBuiltinError("builtin type '" + type + "' is not supported!");
        }
        byte[] bytes = creator.createGrammar(uri);
        return new ByteArrayInputStream(bytes);
    }

    private String extractBuiltinType(URI uri) {
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        String[] path = schemeSpecificPart.split("/");
        String type = path[1];
        int pos = type.indexOf(63);
        if (pos >= 0) {
            type = type.substring(0, pos);
        }
        return type.toLowerCase();
    }

    @Override
    public String getScheme() {
        return SCHEME_NAME;
    }

    @Override
    public void sessionClosed(String sessionId) {
    }
}

