/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.documentserver.schemestrategy.builtin;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.jvoicexml.documentserver.schemestrategy.builtin.AbstractGrammarCreator;
import org.jvoicexml.documentserver.schemestrategy.builtin.GrammarCreator;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.xml.srgs.Grammar;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.Item;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.srgs.OneOf;
import org.jvoicexml.xml.srgs.Rule;
import org.jvoicexml.xml.srgs.Ruleref;
import org.jvoicexml.xml.srgs.SrgsXmlDocument;

public class DigitsGrammarCreator
extends AbstractGrammarCreator
implements GrammarCreator {
    private static final int MAX_DIGIT = 10;
    public static final String TYPE_NAME = "digits";

    @Override
    public byte[] createGrammar(URI uri) throws BadFetchError, IOException {
        SrgsXmlDocument document;
        ModeType mode = this.getMode(uri);
        Map<String, String> parameters = this.getParameters(uri);
        try {
            document = new SrgsXmlDocument();
        }
        catch (ParserConfigurationException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        Grammar grammar = document.getGrammar();
        grammar.setMode(mode);
        if (mode == ModeType.VOICE) {
            grammar.setAttribute("xml:lang", "en");
        }
        grammar.setType(GrammarType.SRGS_XML);
        Rule digit = (Rule)grammar.appendChild(Rule.class);
        digit.setId("digit");
        OneOf oneof = (OneOf)digit.appendChild(OneOf.class);
        for (int i = 0; i < 10; ++i) {
            Item item = (Item)oneof.appendChild(Item.class);
            item.addText(Integer.toString(i));
        }
        Rule digits = (Rule)grammar.appendChild(Rule.class);
        digits.makePublic();
        digits.setId(TYPE_NAME);
        Item digitsItem = (Item)digits.appendChild(Item.class);
        int length = this.getIntParameter(parameters, "length", -1);
        if (length < 0) {
            int min = this.getIntParameter(parameters, "minlength", 1);
            int max = this.getIntParameter(parameters, "maxlength", -1);
            try {
                digitsItem.setRepeat(min, max);
            }
            catch (IllegalArgumentException e) {
                throw new BadFetchError(e.getMessage(), e);
            }
        }
        try {
            digitsItem.setRepeat(length);
        }
        catch (IllegalArgumentException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
        Ruleref ref = (Ruleref)digitsItem.appendChild(Ruleref.class);
        ref.setUri(digit);
        grammar.setRoot(digits);
        return this.getBytes(document);
    }

    private int getIntParameter(Map<String, String> parameters, String name, int defValue) {
        String value = parameters.get(name);
        if (value == null) {
            return defValue;
        }
        return Integer.parseInt(value);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }
}

