/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.dtmf;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.DtmfInput;
import org.jvoicexml.DtmfRecognizerProperties;
import org.jvoicexml.RecognitionResult;
import org.jvoicexml.SpeechRecognizerProperties;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.error.UnsupportedFormatError;
import org.jvoicexml.event.error.UnsupportedLanguageError;
import org.jvoicexml.event.plain.implementation.SpokenInputEvent;
import org.jvoicexml.implementation.GrammarImplementation;
import org.jvoicexml.implementation.SpokenInput;
import org.jvoicexml.implementation.SpokenInputListener;
import org.jvoicexml.implementation.dtmf.DtmfInputResult;
import org.jvoicexml.implementation.dtmf.DtmfInputThread;
import org.jvoicexml.implementation.dtmf.InterdigitTimeoutThread;
import org.jvoicexml.implementation.grammar.GrammarEvaluator;
import org.jvoicexml.implementation.grammar.GrammarParser;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.vxml.BargeInType;

public class BufferedDtmfInput
implements DtmfInput,
SpokenInput {
    private static final Logger LOGGER = LogManager.getLogger(BufferedDtmfInput.class);
    private static final int MAX_DTMF_INPUT = 512;
    private volatile List<Character> buffer = new ArrayList<Character>(512);
    private final Collection<SpokenInputListener> listener = new ArrayList<SpokenInputListener>();
    private volatile Collection<GrammarImplementation<?>> activeGrammars = new ArrayList();
    private Thread inputThread;
    private InterdigitTimeoutThread interDigitTimeout;
    private DtmfRecognizerProperties props;
    private final Map<GrammarType, GrammarParser<?>> parsers = new HashMap();
    private DataModel model;

    public void setGrammarParsers(List<GrammarParser<?>> grammarParsers) {
        for (GrammarParser<?> parser : grammarParsers) {
            GrammarType type = parser.getType();
            this.parsers.put(type, parser);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("added parser '" + parser + "' for grammar type '" + type + "'");
        }
    }

    @Override
    public void activateGrammars(Collection<GrammarImplementation<?>> grammars) throws BadFetchError, UnsupportedLanguageError, NoresourceError {
        this.activeGrammars.addAll(grammars);
        if (LOGGER.isDebugEnabled()) {
            for (GrammarImplementation<?> grammar : grammars) {
                LOGGER.debug("activated DTMF grammar " + grammar.getGrammarDocument());
            }
        }
    }

    @Override
    public void deactivateGrammars(Collection<GrammarImplementation<?>> grammars) throws NoresourceError, BadFetchError {
        this.activeGrammars.removeAll(grammars);
        if (LOGGER.isDebugEnabled()) {
            for (GrammarImplementation<?> grammar : grammars) {
                LOGGER.debug("deactivated DTMF grammar " + grammar.getGrammarDocument());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addDtmf(char dtmf) throws IllegalArgumentException {
        if ("01234567890#*".indexOf(Character.toString(dtmf)) < 0) {
            throw new IllegalArgumentException("'" + dtmf + "' is not one of 0123456789#* ");
        }
        List<Character> list = this.buffer;
        synchronized (list) {
            this.buffer.add(Character.valueOf(dtmf));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("added char '" + dtmf + "' buffer is now '" + this.buffer.toString() + "'");
            }
            this.buffer.notifyAll();
        }
        char termchar = this.props.getTermchar();
        if (dtmf == termchar) {
            return;
        }
        if (this.interDigitTimeout == null) {
            long interdigittimeout = this.props.getInterdigittimeoutAsMsec();
            this.interDigitTimeout = new InterdigitTimeoutThread(this, interdigittimeout, termchar);
            this.interDigitTimeout.start();
        } else {
            this.interDigitTimeout.enteredDigit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    char getNextCharacter() throws InterruptedException {
        List<Character> list = this.buffer;
        synchronized (list) {
            this.buffer.wait();
            return this.buffer.remove(0).charValue();
        }
    }

    @Override
    public synchronized void startRecognition(DataModel dataModel, SpeechRecognizerProperties speech, DtmfRecognizerProperties dtmf) throws NoresourceError, BadFetchError {
        this.model = dataModel;
        this.props = dtmf;
        this.inputThread = new DtmfInputThread(this, this.props);
        this.inputThread.start();
        LOGGER.info("started DTMF recognition");
    }

    public boolean isAccepted(RecognitionResult result) {
        Iterator<GrammarImplementation<?>> iterator = this.activeGrammars.iterator();
        if (iterator.hasNext()) {
            String utterance;
            GrammarEvaluator evaluator;
            Object interpretation;
            GrammarImplementation<?> grammar = iterator.next();
            if (result instanceof DtmfInputResult && grammar instanceof GrammarEvaluator && (interpretation = (evaluator = (GrammarEvaluator)((Object)grammar)).getSemanticInterpretation(this.model, utterance = result.getUtterance())) != null) {
                DtmfInputResult dtmfResult = (DtmfInputResult)result;
                dtmfResult.setSemanticInterpretation(interpretation);
            }
            return true;
        }
        return false;
    }

    @Override
    public void stopRecognition() {
        if (this.inputThread != null) {
            this.inputThread.interrupt();
            this.inputThread = null;
        }
        if (this.interDigitTimeout != null) {
            this.interDigitTimeout.interrupt();
            this.interDigitTimeout = null;
        }
        this.props = null;
        LOGGER.info("stopped DTMF recognition");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(SpokenInputListener inputListener) {
        Collection<SpokenInputListener> collection = this.listener;
        synchronized (collection) {
            this.listener.add(inputListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(SpokenInputListener inputListener) {
        Collection<SpokenInputListener> collection = this.listener;
        synchronized (collection) {
            this.listener.remove(inputListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInputEvent(SpokenInputEvent event) {
        ArrayList<SpokenInputListener> copy = new ArrayList<SpokenInputListener>();
        Collection<SpokenInputListener> collection = this.listener;
        synchronized (collection) {
            copy.addAll(this.listener);
        }
        for (SpokenInputListener current : copy) {
            current.inputStatusChanged(event);
        }
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public void open() throws NoresourceError {
    }

    @Override
    public void activate() throws NoresourceError {
    }

    @Override
    public void passivate() throws NoresourceError {
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public void connect(ConnectionInformation client) throws IOException {
    }

    @Override
    public void disconnect(ConnectionInformation client) {
    }

    @Override
    public Collection<GrammarType> getSupportedGrammarTypes() {
        return this.parsers.keySet();
    }

    @Override
    public GrammarImplementation<?> loadGrammar(URI uri, GrammarType type) throws NoresourceError, IOException, UnsupportedFormatError {
        GrammarParser<?> parser = this.parsers.get(type);
        if (parser == null) {
            throw new UnsupportedFormatError("'" + type + "' is not supported");
        }
        return parser.load(uri);
    }

    @Override
    public Collection<BargeInType> getSupportedBargeInTypes() {
        return null;
    }
}

