/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.dtmf;

import org.jvoicexml.RecognitionResult;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.xml.srgs.ModeType;

class DtmfInputResult
implements RecognitionResult {
    private final String utterance;
    private String marker;
    private boolean accepted;
    private Object interpretation;

    DtmfInputResult(String dtmf) {
        this.utterance = dtmf;
    }

    DtmfInputResult(String dtmf, boolean isAccepted) {
        this.utterance = dtmf;
        this.accepted = isAccepted;
    }

    @Override
    public String getMark() {
        return this.marker;
    }

    @Override
    public String getUtterance() {
        return this.utterance;
    }

    public void setAccepted(boolean isAccepted) {
        this.accepted = isAccepted;
    }

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public void setMark(String mark) {
        this.marker = mark;
    }

    @Override
    public float getConfidence() {
        return 1.0f;
    }

    @Override
    public float[] getWordsConfidence() {
        float[] wordsConfidence = new float[this.utterance.length()];
        for (int i = 0; i < this.utterance.length(); ++i) {
            wordsConfidence[i] = 1.0f;
        }
        return wordsConfidence;
    }

    @Override
    public String[] getWords() {
        String[] words = new String[this.utterance.length()];
        for (int i = 0; i < this.utterance.length(); ++i) {
            char digit = this.utterance.charAt(i);
            words[i] = Character.toString(digit);
        }
        return words;
    }

    @Override
    public ModeType getMode() {
        return ModeType.DTMF;
    }

    public void setSemanticInterpretation(Object object) {
        this.interpretation = object;
    }

    @Override
    public Object getSemanticInterpretation(DataModel model) {
        return this.interpretation;
    }
}

