/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.dtmf;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.DtmfRecognizerProperties;
import org.jvoicexml.event.plain.implementation.InputStartedEvent;
import org.jvoicexml.event.plain.implementation.NomatchEvent;
import org.jvoicexml.event.plain.implementation.RecognitionEvent;
import org.jvoicexml.event.plain.implementation.SpokenInputEvent;
import org.jvoicexml.implementation.SpokenInput;
import org.jvoicexml.implementation.dtmf.BufferedDtmfInput;
import org.jvoicexml.implementation.dtmf.DtmfInputResult;
import org.jvoicexml.xml.srgs.ModeType;

class DtmfInputThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(DtmfInputThread.class);
    private final BufferedDtmfInput input;
    private final DtmfRecognizerProperties props;

    DtmfInputThread(BufferedDtmfInput characterInput, DtmfRecognizerProperties dtmf) {
        this.setDaemon(true);
        this.setName("CharacterInput");
        this.input = characterInput;
        this.props = dtmf;
    }

    @Override
    public void run() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("started DTMF recognition thread");
        }
        boolean sentStartedEvent = false;
        StringBuilder utterance = new StringBuilder();
        char dtmf = '\u0001';
        char termchar = this.props.getTermchar();
        while (!this.isInterrupted() && dtmf != termchar) {
            try {
                dtmf = this.input.getNextCharacter();
                if (!sentStartedEvent) {
                    this.notifyStartEvent();
                    sentStartedEvent = true;
                }
                if (dtmf == termchar) continue;
                utterance.append(dtmf);
            }
            catch (InterruptedException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("reading DTMF interrupted");
                }
                return;
            }
        }
        if (!this.isInterrupted()) {
            String utteranceString = utterance.toString();
            this.notifyInput(utteranceString);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DTMF recognition thread terminated");
        }
    }

    private void notifyStartEvent() {
        InputStartedEvent startedEvent = new InputStartedEvent((SpokenInput)this.input, null, ModeType.DTMF);
        this.input.fireInputEvent(startedEvent);
    }

    private void notifyInput(String utterance) {
        DtmfInputResult result = new DtmfInputResult(utterance);
        boolean accepted = this.input.isAccepted(result);
        result.setAccepted(accepted);
        SpokenInputEvent event = accepted ? new RecognitionEvent((SpokenInput)this.input, null, result) : new NomatchEvent((SpokenInput)this.input, null, result);
        this.input.fireInputEvent(event);
    }
}

