/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.dtmf;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.implementation.dtmf.BufferedDtmfInput;
import org.jvoicexml.implementation.dtmf.DtmfInputThread;

class InterdigitTimeoutThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(DtmfInputThread.class);
    private final BufferedDtmfInput input;
    private boolean enteredDigit;
    private final Object lock;
    private final long interdigittimeout;
    private final char termchar;

    InterdigitTimeoutThread(BufferedDtmfInput characterInput, long timeout, char term) {
        this.setDaemon(true);
        this.setName("InterdigitTimeoutThread");
        this.input = characterInput;
        this.lock = new Object();
        this.interdigittimeout = timeout;
        this.termchar = term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("started interdigit timeout thread with a timeout of " + this.interdigittimeout + " msecs");
        }
        do {
            this.enteredDigit = false;
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(this.interdigittimeout);
                }
                catch (InterruptedException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("interdigit timeout thread interrupted", (Throwable)e);
                    }
                    return;
                }
            }
        } while (this.enteredDigit);
        this.input.addDtmf(this.termchar);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("interdigit timeout thread terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enteredDigit() {
        this.enteredDigit = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

