/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.grammar;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.implementation.GrammarImplementation;
import org.jvoicexml.implementation.grammar.LoadedGrammar;

public final class GrammarCache {
    private final Set<LoadedGrammar> grammars = new HashSet<LoadedGrammar>();

    public int size() {
        return this.grammars.size();
    }

    public void add(LoadedGrammar grammar) {
        this.grammars.add(grammar);
    }

    public Collection<GrammarImplementation<?>> getImplementations() {
        ArrayList col = new ArrayList();
        for (LoadedGrammar grammar : this.grammars) {
            GrammarImplementation<?> impl = grammar.getImplementation();
            col.add(impl);
        }
        return col;
    }

    public LoadedGrammar get(GrammarDocument document) {
        for (LoadedGrammar grammar : this.grammars) {
            GrammarDocument current = grammar.getDocument();
            if (!current.equals(document)) continue;
            return grammar;
        }
        return null;
    }

    public GrammarImplementation<?> getImplementation(GrammarDocument document) {
        LoadedGrammar grammar = this.get(document);
        if (grammar == null) {
            return null;
        }
        return grammar.getImplementation();
    }

    public boolean contains(GrammarDocument document) {
        for (LoadedGrammar grammar : this.grammars) {
            GrammarDocument current = grammar.getDocument();
            if (!current.equals(document)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(GrammarImplementation<?> implementation) {
        for (LoadedGrammar grammar : this.grammars) {
            GrammarImplementation<?> current = grammar.getImplementation();
            if (!current.equals((Object)implementation)) continue;
            return true;
        }
        return false;
    }
}

