/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.CallControlProperties;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.implementation.AudioSource;
import org.jvoicexml.implementation.SpokenInput;
import org.jvoicexml.implementation.SynthesizedOutput;
import org.jvoicexml.implementation.Telephony;
import org.jvoicexml.implementation.TelephonyEvent;
import org.jvoicexml.implementation.TelephonyListener;
import org.jvoicexml.implementation.jvxml.RecordingThread;
import org.jvoicexml.implementation.jvxml.SpeakerOutputStream;

public final class DesktopTelephonySupport
implements Telephony {
    private static final Logger LOGGER = LogManager.getLogger(DesktopTelephonySupport.class);
    private final AudioFormat recordingAudioFormat;
    private final Collection<TelephonyListener> listener = new ArrayList<TelephonyListener>();
    private boolean busy;
    private boolean active;
    private RecordingThread recording;
    private SpeakerOutputStream out;

    public DesktopTelephonySupport(AudioFormat format) {
        this.recordingAudioFormat = format;
    }

    @Override
    public void activate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("activated telephony");
        }
    }

    @Override
    public void close() {
    }

    @Override
    public String getType() {
        return "desktop";
    }

    @Override
    public void open() throws NoresourceError {
    }

    @Override
    public void passivate() {
        if (this.recording != null) {
            this.recording.stopRecording();
            this.recording = null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("passivated telephony");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(ConnectionInformation client) throws IOException {
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            ArrayList<TelephonyListener> copy = new ArrayList<TelephonyListener>();
            copy.addAll(this.listener);
            TelephonyEvent event = new TelephonyEvent(this, 1);
            for (TelephonyListener current : copy) {
                current.telephonyCallAnswered(event);
            }
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(ConnectionInformation client) {
        this.active = false;
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            ArrayList<TelephonyListener> copy = new ArrayList<TelephonyListener>();
            copy.addAll(this.listener);
            TelephonyEvent event = new TelephonyEvent(this, 2);
            for (TelephonyListener current : copy) {
                current.telephonyCallHungup(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void play(SynthesizedOutput output, CallControlProperties props) throws IOException, NoresourceError {
        if (!this.active) {
            throw new NoresourceError("desktop telephony is no longer active");
        }
        if (output instanceof AudioSource) {
            AudioSource source = (AudioSource)((Object)output);
            try {
                this.play(source);
            }
            catch (LineUnavailableException e) {
                throw new NoresourceError(e.getMessage(), e);
            }
        }
        this.busy = true;
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            ArrayList<TelephonyListener> copy = new ArrayList<TelephonyListener>();
            copy.addAll(this.listener);
            TelephonyEvent event = new TelephonyEvent(this, 4);
            for (TelephonyListener current : copy) {
                current.telephonyMediaEvent(event);
            }
        }
    }

    private void play(AudioSource source) throws LineUnavailableException, IOException {
        AudioFormat format = source.getAudioFormat();
        this.out = new SpeakerOutputStream(format);
        this.out.open();
        source.setOutputStream(this.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPlay() throws NoresourceError {
        if (!this.busy) {
            return;
        }
        this.busy = false;
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                throw new NoresourceError(e.getMessage(), e);
            }
            finally {
                this.out = null;
            }
        }
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            ArrayList<TelephonyListener> copy = new ArrayList<TelephonyListener>();
            copy.addAll(this.listener);
            TelephonyEvent event = new TelephonyEvent(this, 8);
            for (TelephonyListener current : copy) {
                current.telephonyMediaEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(SpokenInput input, CallControlProperties props) throws IOException, NoresourceError {
        if (!this.active) {
            throw new NoresourceError("desktop telephony is no longer active");
        }
        this.busy = true;
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            ArrayList<TelephonyListener> copy = new ArrayList<TelephonyListener>();
            copy.addAll(this.listener);
            TelephonyEvent event = new TelephonyEvent(this, 16);
            for (TelephonyListener current : copy) {
                current.telephonyMediaEvent(event);
            }
        }
    }

    @Override
    public AudioFormat getRecordingAudioFormat() {
        return this.recordingAudioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startRecording(SpokenInput input, OutputStream stream, CallControlProperties props) throws IOException, NoresourceError {
        if (!this.active) {
            throw new NoresourceError("desktop telephony is no longer active");
        }
        this.busy = true;
        try {
            this.recording = new RecordingThread(stream, this.recordingAudioFormat);
            this.recording.start();
        }
        catch (LineUnavailableException e) {
            throw new IOException(e.getMessage(), e);
        }
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            ArrayList<TelephonyListener> copy = new ArrayList<TelephonyListener>();
            copy.addAll(this.listener);
            TelephonyEvent event = new TelephonyEvent(this, 16);
            for (TelephonyListener current : copy) {
                current.telephonyMediaEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopRecording() throws NoresourceError {
        if (!this.busy) {
            return;
        }
        this.busy = false;
        if (this.recording != null) {
            this.recording.stopRecording();
            this.recording = null;
        }
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            ArrayList<TelephonyListener> copy = new ArrayList<TelephonyListener>();
            copy.addAll(this.listener);
            TelephonyEvent event = new TelephonyEvent(this, 32);
            for (TelephonyListener current : copy) {
                current.telephonyMediaEvent(event);
            }
        }
    }

    @Override
    public void transfer(String dest) throws NoresourceError {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hangup() {
        this.active = false;
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            ArrayList<TelephonyListener> copy = new ArrayList<TelephonyListener>();
            copy.addAll(this.listener);
            TelephonyEvent event = new TelephonyEvent(this, 2);
            for (TelephonyListener current : copy) {
                current.telephonyCallHungup(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TelephonyListener callListener) {
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            this.listener.add(callListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TelephonyListener callListener) {
        Collection<TelephonyListener> collection = this.listener;
        synchronized (collection) {
            this.listener.add(callListener);
        }
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }
}

