/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.CallControl;
import org.jvoicexml.CallControlProperties;
import org.jvoicexml.SystemOutput;
import org.jvoicexml.UserInput;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.implementation.SpokenInput;
import org.jvoicexml.implementation.SpokenInputProvider;
import org.jvoicexml.implementation.SynthesizedOutput;
import org.jvoicexml.implementation.SynthesizedOutputProvider;
import org.jvoicexml.implementation.Telephony;

final class JVoiceXmlCallControl
implements CallControl {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlCallControl.class);
    private final Telephony telephony;

    JVoiceXmlCallControl(Telephony tel) {
        this.telephony = tel;
    }

    @Override
    public void play(SystemOutput output, CallControlProperties props) throws NoresourceError, IOException {
        if (output instanceof SynthesizedOutputProvider) {
            SynthesizedOutputProvider provider = (SynthesizedOutputProvider)((Object)output);
            SynthesizedOutput synthesizer = provider.getSynthesizedOutput();
            this.telephony.play(synthesizer, props);
        } else {
            LOGGER.warn("unable to retrieve a synthesized output from " + output);
        }
    }

    @Override
    public void stopPlay() throws NoresourceError {
        this.telephony.stopPlay();
    }

    @Override
    public void record(UserInput input, CallControlProperties props) throws NoresourceError, IOException {
        if (input instanceof SpokenInputProvider) {
            SpokenInputProvider provider = (SpokenInputProvider)((Object)input);
            SpokenInput recognizer = provider.getSpokenInput();
            this.telephony.record(recognizer, props);
        } else {
            LOGGER.warn("unable to retrieve a recognizer output from " + input);
        }
    }

    @Override
    public AudioFormat getRecordingAudioFormat() {
        return this.telephony.getRecordingAudioFormat();
    }

    @Override
    public void startRecording(UserInput input, OutputStream stream, CallControlProperties props) throws NoresourceError, IOException {
        if (input instanceof SpokenInputProvider) {
            SpokenInputProvider provider = (SpokenInputProvider)((Object)input);
            SpokenInput recognizer = provider.getSpokenInput();
            this.telephony.startRecording(recognizer, stream, props);
        } else {
            LOGGER.warn("unable to retrieve a recognizer output from " + input);
        }
    }

    @Override
    public void stopRecord() throws NoresourceError {
        this.telephony.stopRecording();
    }

    @Override
    public void transfer(String dest) throws NoresourceError {
        this.telephony.transfer(dest);
    }

    public Telephony getTelephony() {
        return this.telephony;
    }

    public boolean isBusy() {
        return this.telephony.isBusy();
    }

    @Override
    public void hangup() {
        block3: {
            LOGGER.info("terminating telephony");
            if (this.telephony.isBusy()) {
                try {
                    this.telephony.stopPlay();
                    this.telephony.stopRecording();
                }
                catch (NoresourceError e) {
                    if (!LOGGER.isDebugEnabled()) break block3;
                    LOGGER.debug("error stopping telephony", (Throwable)e);
                }
            }
        }
        this.telephony.hangup();
    }

    @Override
    public boolean isCallActive() {
        return this.telephony.isActive();
    }
}

