/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import java.io.IOException;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.CallControl;
import org.jvoicexml.CallControlProperties;
import org.jvoicexml.Configurable;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConfigurationException;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.DtmfInput;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.RecognitionResult;
import org.jvoicexml.Session;
import org.jvoicexml.SpeakableText;
import org.jvoicexml.SystemOutput;
import org.jvoicexml.UserInput;
import org.jvoicexml.event.ErrorEvent;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.plain.ConnectionDisconnectHangupEvent;
import org.jvoicexml.event.plain.implementation.InputStartedEvent;
import org.jvoicexml.event.plain.implementation.MarkerReachedEvent;
import org.jvoicexml.event.plain.implementation.NomatchEvent;
import org.jvoicexml.event.plain.implementation.OutputEndedEvent;
import org.jvoicexml.event.plain.implementation.OutputStartedEvent;
import org.jvoicexml.event.plain.implementation.QueueEmptyEvent;
import org.jvoicexml.event.plain.implementation.RecognitionEvent;
import org.jvoicexml.event.plain.implementation.RecognitionStartedEvent;
import org.jvoicexml.event.plain.implementation.RecognitionStoppedEvent;
import org.jvoicexml.event.plain.implementation.SpokenInputEvent;
import org.jvoicexml.event.plain.implementation.SynthesizedOutputEvent;
import org.jvoicexml.event.plain.jvxml.TransferEvent;
import org.jvoicexml.implementation.ExternalResource;
import org.jvoicexml.implementation.SpokenInput;
import org.jvoicexml.implementation.SpokenInputListener;
import org.jvoicexml.implementation.SynthesizedOutput;
import org.jvoicexml.implementation.SynthesizedOutputListener;
import org.jvoicexml.implementation.Telephony;
import org.jvoicexml.implementation.TelephonyEvent;
import org.jvoicexml.implementation.TelephonyListener;
import org.jvoicexml.implementation.dtmf.BufferedDtmfInput;
import org.jvoicexml.implementation.jvxml.ImplementationPlatformReaper;
import org.jvoicexml.implementation.jvxml.JVoiceXmlCallControl;
import org.jvoicexml.implementation.jvxml.JVoiceXmlPromptAccumulator;
import org.jvoicexml.implementation.jvxml.JVoiceXmlSystemOutput;
import org.jvoicexml.implementation.jvxml.JVoiceXmlUserInput;
import org.jvoicexml.implementation.jvxml.TimerThread;
import org.jvoicexml.implementation.pool.KeyedResourcePool;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.vxml.BargeInType;

public final class JVoiceXmlImplementationPlatform
implements SpokenInputListener,
SynthesizedOutputListener,
TelephonyListener,
ImplementationPlatform,
Configurable {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlImplementationPlatform.class);
    private static final int BUSY_WAIT_TIMEOUT = 1000;
    private final KeyedResourcePool<SynthesizedOutput> synthesizerPool;
    private final Object synthesizerPoolLock;
    private final KeyedResourcePool<SpokenInput> recognizerPool;
    private final Object recognizerPoolLock;
    private final KeyedResourcePool<Telephony> telephonyPool;
    private final Object telephonyPoolLock;
    private final ConnectionInformation info;
    private JVoiceXmlSystemOutput output;
    private JVoiceXmlUserInput input;
    private final Object inputLock;
    private volatile BufferedDtmfInput dtmfInput;
    private JVoiceXmlCallControl call;
    private EventBus eventbus;
    private TimerThread timer;
    private String markname;
    private boolean closed;
    private boolean hungup;
    private Session session;
    private final JVoiceXmlPromptAccumulator promptAccumulator;
    private ImplementationPlatformReaper reaper;

    JVoiceXmlImplementationPlatform(KeyedResourcePool<Telephony> telePool, KeyedResourcePool<SynthesizedOutput> synthesizedOutputPool, KeyedResourcePool<SpokenInput> spokenInputPool, ConnectionInformation connectionInformation) {
        this(telePool, synthesizedOutputPool, spokenInputPool, new BufferedDtmfInput(), connectionInformation);
    }

    JVoiceXmlImplementationPlatform(KeyedResourcePool<Telephony> telePool, KeyedResourcePool<SynthesizedOutput> synthesizedOutputPool, KeyedResourcePool<SpokenInput> spokenInputPool, BufferedDtmfInput bufferedCharacterInput, ConnectionInformation connectionInformation) {
        this.info = connectionInformation;
        this.telephonyPool = telePool;
        this.telephonyPoolLock = new Object();
        this.synthesizerPool = synthesizedOutputPool;
        this.synthesizerPoolLock = new Object();
        this.recognizerPool = spokenInputPool;
        this.recognizerPoolLock = new Object();
        this.dtmfInput = bufferedCharacterInput;
        this.inputLock = new Object();
        this.promptAccumulator = new JVoiceXmlPromptAccumulator(this);
    }

    @Override
    public void init(Configuration configuration) throws ConfigurationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemOutput getSystemOutput() throws NoresourceError, ConnectionDisconnectHangupEvent {
        JVoiceXmlImplementationPlatform jVoiceXmlImplementationPlatform = this;
        synchronized (jVoiceXmlImplementationPlatform) {
            if (this.hungup) {
                throw new ConnectionDisconnectHangupEvent("caller hung up");
            }
            if (this.closed) {
                throw new NoresourceError("implementation platform closed");
            }
        }
        String type = this.info.getSystemOutput();
        Object object = this.synthesizerPoolLock;
        synchronized (object) {
            if (this.output == null) {
                SynthesizedOutput synthesizer = this.getExternalResourceFromPool(this.synthesizerPool, type);
                this.output = new JVoiceXmlSystemOutput(synthesizer, this.session);
                this.output.addListener(this);
                LOGGER.info("borrowed system output of type '" + type + "'");
            }
            return this.output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnSystemOutput() {
        Object object = this.synthesizerPoolLock;
        synchronized (object) {
            if (this.output == null) {
                return;
            }
            if (!this.hungup && !this.closed && this.output.isBusy()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("output still busy. returning when queue is empty");
                }
                this.maybeStartReaper();
            } else {
                this.maybeStopReaper();
                JVoiceXmlSystemOutput systemOutput = this.output;
                this.output = null;
                String type = this.info.getSystemOutput();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("returning system output of type '" + type + "'...");
                }
                systemOutput.removeListener(this);
                SynthesizedOutput synthesizedOutput = systemOutput.getSynthesizedOutput();
                this.returnExternalResourceToPool(this.synthesizerPool, synthesizedOutput);
                LOGGER.info("returned system output of type '" + type + "'");
            }
        }
    }

    private void maybeStartReaper() {
        if (this.reaper != null) {
            return;
        }
        this.reaper = new ImplementationPlatformReaper(this);
        this.reaper.start();
    }

    private void maybeStopReaper() {
        if (this.reaper == null) {
            return;
        }
        this.reaper.stopReaping();
        this.reaper = null;
    }

    @Override
    public void waitOutputQueueEmpty() {
        if (this.output == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("waiting for empty output queue...");
        }
        SynthesizedOutput synthesizedOutput = this.output.getSynthesizedOutput();
        synthesizedOutput.waitQueueEmpty();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...output queue empty.");
        }
    }

    @Override
    public void waitNonBargeInPlayed() {
        if (this.output == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("waiting for non-barge-in played...");
        }
        SynthesizedOutput synthesizedOutput = this.output.getSynthesizedOutput();
        synthesizedOutput.waitNonBargeInPlayed();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...non-barge-in played.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInput getUserInput() throws NoresourceError, ConnectionDisconnectHangupEvent {
        JVoiceXmlImplementationPlatform jVoiceXmlImplementationPlatform = this;
        synchronized (jVoiceXmlImplementationPlatform) {
            if (this.hungup) {
                throw new ConnectionDisconnectHangupEvent("caller hung up");
            }
            if (this.closed) {
                throw new NoresourceError("implementation platform closed");
            }
        }
        String type = this.info.getUserInput();
        Object object = this.recognizerPoolLock;
        synchronized (object) {
            if (this.input == null) {
                SpokenInput spokenInput = this.getExternalResourceFromPool(this.recognizerPool, type);
                this.input = new JVoiceXmlUserInput(spokenInput, this.dtmfInput);
                this.input.addListener(this);
                LOGGER.info("borrowed user input of type '" + type + "'");
            }
        }
        return this.input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserInputActive() {
        ConnectionInformation connectionInformation = this.info;
        synchronized (connectionInformation) {
            return this.input != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnUserInput() {
        Object object = this.recognizerPoolLock;
        synchronized (object) {
            if (this.input == null) {
                return;
            }
            if (!this.hungup && !this.closed && this.input.isBusy()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("input still busy. returning when recognition is stopped");
                }
            } else {
                JVoiceXmlUserInput userInput = this.input;
                this.input = null;
                String type = this.info.getUserInput();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("returning user input of type '" + type + "'...");
                }
                userInput.removeListener(this);
                SpokenInput spokenInput = userInput.getSpokenInput();
                this.returnExternalResourceToPool(this.recognizerPool, spokenInput);
                LOGGER.info("returned user input of type '" + type + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DtmfInput getCharacterInput() throws NoresourceError, ConnectionDisconnectHangupEvent {
        JVoiceXmlImplementationPlatform jVoiceXmlImplementationPlatform = this;
        synchronized (jVoiceXmlImplementationPlatform) {
            if (this.hungup) {
                throw new ConnectionDisconnectHangupEvent("caller hung up");
            }
            if (this.closed) {
                throw new NoresourceError("implementation platform closed");
            }
        }
        return this.dtmfInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallControl getCallControl() throws NoresourceError, ConnectionDisconnectHangupEvent {
        JVoiceXmlImplementationPlatform jVoiceXmlImplementationPlatform = this;
        synchronized (jVoiceXmlImplementationPlatform) {
            if (this.hungup) {
                throw new ConnectionDisconnectHangupEvent("caller hung up");
            }
            if (this.closed) {
                throw new NoresourceError("implementation platform closed");
            }
        }
        String type = this.info.getCallControl();
        Object object = this.telephonyPoolLock;
        synchronized (object) {
            if (this.call == null) {
                Telephony telephony = this.getExternalResourceFromPool(this.telephonyPool, type);
                telephony.addListener(this);
                this.call = new JVoiceXmlCallControl(telephony);
                LOGGER.info("borrowed call control of type '" + type + "'");
            }
            return this.call;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnCallControl() {
        Object object = this.telephonyPoolLock;
        synchronized (object) {
            if (this.call == null) {
                return;
            }
            if (!this.hungup && !this.closed && this.call.isBusy()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("call control still busy. returning when queue is empty");
                }
            } else {
                JVoiceXmlCallControl callControl = this.call;
                this.call = null;
                String type = this.info.getCallControl();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("returning call control of type '" + type + "'...");
                }
                Telephony telephony = callControl.getTelephony();
                this.returnExternalResourceToPool(this.telephonyPool, telephony);
                LOGGER.info("returned call control of type '" + type + "'");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        JVoiceXmlImplementationPlatform jVoiceXmlImplementationPlatform = this;
        synchronized (jVoiceXmlImplementationPlatform) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        LOGGER.info("closing implementation platform");
        this.maybeStopReaper();
        if (this.output != null && !this.hungup) {
            this.waitOutputQueueEmpty();
        }
        if (this.timer != null) {
            this.timer.stopTimer();
            this.timer = null;
        }
        if (this.input != null) {
            if (this.hungup) {
                this.input.stopRecognition(null);
            } else {
                try {
                    this.waitInputNotBusy();
                }
                catch (Exception e) {
                    LOGGER.warn("error waiting for input not busy", (Throwable)e);
                }
            }
        }
        LOGGER.info("returning aqcuired resources");
        this.returnSystemOutput();
        this.returnUserInput();
        this.returnCallControl();
        LOGGER.info("implementation platform closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitInputNotBusy() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("waiting for empty input not busy...");
        }
        while (this.input.isBusy()) {
            ConnectionInformation connectionInformation = this.info;
            synchronized (connectionInformation) {
                try {
                    this.inputLock.wait(1000L);
                }
                catch (InterruptedException e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("waiting for input not busy interrupted", (Throwable)e);
                    }
                    return;
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...input not busy.");
        }
    }

    @Override
    public void setEventBus(EventBus bus) {
        this.eventbus = bus;
    }

    private void inputStarted(ModeType type) {
        if (this.timer != null) {
            this.timer.stopTimer();
            this.timer = null;
        }
        if (this.output == null) {
            return;
        }
        Collection<BargeInType> types = this.input.getSupportedBargeInTypes();
        if (types.contains(BargeInType.SPEECH)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            if (type == null) {
                LOGGER.debug("input started 'unknown mode': stopping system output...");
            } else {
                LOGGER.debug("input started: '" + type.getMode() + "' stopping system output...");
            }
        }
        try {
            this.output.cancelOutput(BargeInType.SPEECH);
        }
        catch (NoresourceError nre) {
            LOGGER.warn("unable to stop speech output", (Throwable)nre);
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...system output stopped");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultAccepted(RecognitionResult result) {
        LOGGER.info("accepted recognition '" + result.getUtterance() + "'");
        if (this.eventbus != null) {
            result.setMark(this.markname);
            RecognitionEvent recognitionEvent = new RecognitionEvent(this.input.getSpokenInput(), this.session.getSessionId(), result);
            this.eventbus.publish(recognitionEvent);
        }
        this.markname = null;
        Object object = this.inputLock;
        synchronized (object) {
            this.inputLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultRejected(RecognitionResult result) {
        LOGGER.info("rejected recognition '" + result.getUtterance() + "'");
        if (this.eventbus != null) {
            result.setMark(this.markname);
            NomatchEvent noMatchEvent = new NomatchEvent(this.input.getSpokenInput(), this.session.getSessionId(), result);
            this.eventbus.publish(noMatchEvent);
        }
        Object object = this.inputLock;
        synchronized (object) {
            this.inputLock.notifyAll();
        }
    }

    private <T extends ExternalResource> T getExternalResourceFromPool(KeyedResourcePool<T> pool, String key) throws NoresourceError {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("obtaining resource '" + key + "' from pool...");
        }
        T resource = pool.borrowObject(key);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("connecting external resource (" + resource.getClass().getCanonicalName() + ").");
        }
        try {
            resource.connect(this.info);
        }
        catch (IOException ioe) {
            try {
                pool.returnObject(key, resource);
            }
            catch (Exception e) {
                LOGGER.error("error returning resource to pool", (Throwable)e);
            }
            throw new NoresourceError("error connecting to resource: " + ioe.getMessage(), ioe);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...connected");
        }
        return resource;
    }

    private <T extends ExternalResource> void returnExternalResourceToPool(KeyedResourcePool<T> pool, T resource) {
        String type = resource.getType();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("returning external resource '" + type + "' (" + resource.getClass().getCanonicalName() + ") to pool...");
            LOGGER.debug("disconnecting external resource.");
        }
        resource.disconnect(this.info);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...disconnected");
        }
        try {
            pool.returnObject(type, resource);
        }
        catch (NoresourceError e) {
            LOGGER.error("error returning external resource to pool", (Throwable)e);
        }
        LOGGER.info("returned external resource '" + type + "' (" + resource.getClass().getCanonicalName() + ") to pool");
    }

    @Override
    public void inputStatusChanged(SpokenInputEvent event) {
        if (event.isType(RecognitionStartedEvent.EVENT_TYPE)) {
            SpeakableText lastSpeakable = this.promptAccumulator.getLastSpeakableText();
            if (lastSpeakable == null) {
                this.startTimer();
            }
        } else if (event.isType(InputStartedEvent.EVENT_TYPE)) {
            InputStartedEvent started = (InputStartedEvent)event;
            ModeType modeType = started.getMode();
            this.inputStarted(modeType);
        } else if (event.isType(RecognitionEvent.EVENT_TYPE)) {
            RecognitionEvent recognitionEvent = (RecognitionEvent)event;
            RecognitionResult result = recognitionEvent.getRecognitionResult();
            this.resultAccepted(result);
        } else if (event.isType("nomatch")) {
            NomatchEvent nomatch = (NomatchEvent)event;
            RecognitionResult result = nomatch.getRecognitionResult();
            this.resultRejected(result);
        } else if (event.isType(RecognitionStoppedEvent.EVENT_TYPE)) {
            this.recognitionStopped();
        } else {
            LOGGER.warn("unknown spoken input event " + event);
        }
        this.eventbus.publish(event);
    }

    private synchronized void startTimer() {
        if (this.timer != null) {
            return;
        }
        long timeout = this.promptAccumulator.getPromptTimeout();
        if (timeout > 0L) {
            this.timer = new TimerThread(this.eventbus, timeout);
            this.timer.start();
        }
    }

    private void recognitionStopped() {
        LOGGER.info("recognition stopped");
        if (this.timer != null) {
            this.timer.stopTimer();
            this.timer = null;
        }
        if (this.call != null) {
            LOGGER.info("will stop call recording");
            try {
                this.call.stopRecord();
            }
            catch (NoresourceError ex) {
                ex.printStackTrace();
            }
            LOGGER.info("done stop record request");
        }
        if (this.hungup) {
            this.returnUserInput();
        }
    }

    @Override
    public void telephonyCallAnswered(TelephonyEvent event) {
    }

    @Override
    public void dtmfInput(char dtmf) {
        this.dtmfInput.addDtmf(dtmf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void telephonyCallHungup(TelephonyEvent event) {
        JVoiceXmlImplementationPlatform jVoiceXmlImplementationPlatform = this;
        synchronized (jVoiceXmlImplementationPlatform) {
            if (this.hungup) {
                return;
            }
            this.hungup = true;
        }
        LOGGER.info("telephony connection closed");
        if (this.eventbus != null) {
            ConnectionDisconnectHangupEvent hangupEvent = new ConnectionDisconnectHangupEvent("caller hung up");
            this.eventbus.publish(hangupEvent);
        }
        LOGGER.info("returning aqcuired resources");
        this.returnSystemOutput();
        this.returnUserInput();
        this.returnCallControl();
        LOGGER.info("implementation platform closed");
    }

    @Override
    public void telephonyCallTransferred(TelephonyEvent event) {
        LOGGER.info("call transfered to '" + event.getParam() + "'");
        if (this.eventbus != null) {
            String uri = (String)event.getParam();
            TransferEvent transferEvent = new TransferEvent(uri, null);
            this.eventbus.publish(transferEvent);
        }
    }

    @Override
    public void telephonyMediaEvent(TelephonyEvent event) {
    }

    @Override
    public void outputStatusChanged(SynthesizedOutputEvent event) {
        if (this.eventbus != null) {
            this.eventbus.publish(event);
        }
        if (event.isType(OutputStartedEvent.EVENT_TYPE)) {
            OutputStartedEvent outputStartedEvent = (OutputStartedEvent)event;
            SpeakableText startedSpeakable = outputStartedEvent.getSpeakable();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("output started " + startedSpeakable);
            }
        } else if (event.isType(OutputEndedEvent.EVENT_TYPE)) {
            OutputEndedEvent outputEndedEvent = (OutputEndedEvent)event;
            SpeakableText endedSpeakable = outputEndedEvent.getSpeakable();
            this.outputEnded(endedSpeakable);
        } else if (event.isType(QueueEmptyEvent.EVENT_TYPE)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("output queue is empty");
            }
        } else if (event.isType(MarkerReachedEvent.EVENT_TYPE)) {
            MarkerReachedEvent markReachedEvent = (MarkerReachedEvent)event;
            this.markname = markReachedEvent.getMark();
            LOGGER.info("reached mark '" + this.markname + "'");
        } else {
            LOGGER.warn("unknown synthesized output event " + event);
        }
    }

    private void outputEnded(SpeakableText speakable) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("output ended " + speakable.getSpeakableText());
        }
        if (this.call != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info("will stop call playing");
            }
            try {
                this.call.stopPlay();
            }
            catch (NoresourceError ex) {
                LOGGER.warn("error stopping play", (Throwable)ex);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info("done stop play request");
            }
        }
        if (this.hungup) {
            this.returnSystemOutput();
            return;
        }
        if (this.eventbus == null) {
            return;
        }
        SpeakableText lastSpeakable = this.promptAccumulator.getLastSpeakableText();
        if (speakable.equals(lastSpeakable)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("reached last speakable. starting timer");
            }
            this.startTimer();
        }
    }

    @Override
    public void setSession(Session currentSession) {
        this.session = currentSession;
    }

    @Override
    public void outputError(ErrorEvent error) {
        this.reportError(error);
    }

    @Override
    public void inputError(ErrorEvent error) {
        this.reportError(error);
    }

    @Override
    public void telephonyError(ErrorEvent error) {
        this.reportError(error);
    }

    private void reportError(ErrorEvent error) {
        if (this.eventbus == null) {
            LOGGER.warn("no event observer. unable to propagate an error", (Throwable)error);
            return;
        }
        this.eventbus.publish(error);
    }

    @Override
    public void setPromptTimeout(long timeout) {
        this.promptAccumulator.setPromptTimeout(timeout);
    }

    @Override
    public void queuePrompt(SpeakableText speakable) {
        this.promptAccumulator.queuePrompt(speakable);
    }

    @Override
    public void renderPrompts(String sessionId, DocumentServer server, CallControlProperties props) throws BadFetchError, NoresourceError, ConnectionDisconnectHangupEvent {
        this.promptAccumulator.renderPrompts(sessionId, server, props);
    }
}

