/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.Configuration;
import org.jvoicexml.ConfigurationException;
import org.jvoicexml.ConnectionInformation;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.ImplementationPlatformFactory;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.implementation.PlatformFactory;
import org.jvoicexml.implementation.ResourceFactory;
import org.jvoicexml.implementation.SpokenInput;
import org.jvoicexml.implementation.SynthesizedOutput;
import org.jvoicexml.implementation.Telephony;
import org.jvoicexml.implementation.dtmf.BufferedDtmfInput;
import org.jvoicexml.implementation.jvxml.JVoiceXmlImplementationPlatform;
import org.jvoicexml.implementation.jvxml.TerminationThread;
import org.jvoicexml.implementation.pool.KeyedResourcePool;

public final class JVoiceXmlImplementationPlatformFactory
implements ImplementationPlatformFactory {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlImplementationPlatformFactory.class);
    private final KeyedResourcePool<SynthesizedOutput> synthesizerPool = new KeyedResourcePool();
    private final KeyedResourcePool<SpokenInput> spokenInputPool = new KeyedResourcePool();
    private final KeyedResourcePool<Telephony> telephonyPool = new KeyedResourcePool();
    private Configuration configuration;

    @Override
    public void init(Configuration config) throws ConfigurationException {
        Collection<PlatformFactory> factories = config.loadObjects(PlatformFactory.class, "implementation");
        for (PlatformFactory platformFactory : factories) {
            try {
                this.addPlatform(platformFactory);
            }
            catch (Exception e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
        }
        Collection<ResourceFactory> resourceFactories = config.loadObjects(ResourceFactory.class, "implementation");
        try {
            for (ResourceFactory resourceFactory : resourceFactories) {
                Class clazz = resourceFactory.getResourceType();
                if (clazz.equals(SpokenInput.class)) {
                    this.addSpokenInputFactory(resourceFactory);
                    continue;
                }
                if (clazz.equals(SynthesizedOutput.class)) {
                    this.addSynthesizedOutputFactory(resourceFactory);
                    continue;
                }
                if (!clazz.equals(Telephony.class)) continue;
                this.addTelephonyFactory(resourceFactory);
            }
        }
        catch (Exception | UnsatisfiedLinkError throwable) {
            throw new ConfigurationException(throwable.getMessage(), throwable);
        }
        this.reportPlatforms();
        this.configuration = config;
    }

    private void reportPlatforms() {
        Collection<String> synthesizers = this.synthesizerPool.getKeys();
        if (synthesizers.isEmpty()) {
            LOGGER.warn("no synthesizers available");
        } else {
            LOGGER.info("available synthesizers:");
            for (String string : synthesizers) {
                int avail = this.synthesizerPool.getNumIdle(string);
                LOGGER.info("- " + avail + " instance(s) of type '" + string + "'");
            }
        }
        Collection<String> recognizers = this.spokenInputPool.getKeys();
        if (recognizers.isEmpty()) {
            LOGGER.warn("no recognizers available");
        } else {
            LOGGER.info("available recognizers:");
            for (String key : recognizers) {
                int avail = this.spokenInputPool.getNumIdle(key);
                LOGGER.info("- " + avail + " instance(s) of type '" + key + "'");
            }
        }
        Collection<String> collection = this.telephonyPool.getKeys();
        if (collection.isEmpty()) {
            LOGGER.warn("no telephones available");
        } else {
            LOGGER.info("available telephones:");
            for (String key : collection) {
                int avail = this.telephonyPool.getNumIdle(key);
                LOGGER.info("- " + avail + " instance(s) of type '" + key + "'");
            }
        }
    }

    public void addPlatform(PlatformFactory platform) throws Exception {
        ResourceFactory<Telephony> telephonyFactory;
        ResourceFactory<SpokenInput> spokenInputFactory;
        ResourceFactory<SynthesizedOutput> synthesizedOutputFactory = platform.getSynthesizedoutput();
        if (synthesizedOutputFactory != null) {
            this.addSynthesizedOutputFactory(synthesizedOutputFactory);
        }
        if ((spokenInputFactory = platform.getSpokeninput()) != null) {
            this.addSpokenInputFactory(spokenInputFactory);
        }
        if ((telephonyFactory = platform.getTelephony()) != null) {
            this.addTelephonyFactory(telephonyFactory);
        }
    }

    private void addSynthesizedOutputFactory(ResourceFactory<SynthesizedOutput> factory) throws Exception {
        String type = factory.getType();
        this.synthesizerPool.addResourceFactory(factory);
        LOGGER.info("added synthesized output factory " + factory.getClass() + " for type '" + type + "'");
    }

    public void addSpokenInputFactory(ResourceFactory<SpokenInput> factory) throws Exception {
        String type = factory.getType();
        this.spokenInputPool.addResourceFactory(factory);
        LOGGER.info("added user input factory " + factory.getClass() + " for type '" + type + "'");
    }

    public void addTelephonyFactory(ResourceFactory<Telephony> factory) throws Exception {
        String type = factory.getType();
        this.telephonyPool.addResourceFactory(factory);
        LOGGER.info("added telephony factory " + factory.getClass() + " for type '" + type + "'");
    }

    @Override
    public synchronized ImplementationPlatform getImplementationPlatform(ConnectionInformation info) throws NoresourceError {
        if (info == null) {
            throw new NoresourceError("No connection information given!");
        }
        try {
            BufferedDtmfInput input = this.configuration.loadObject(BufferedDtmfInput.class);
            JVoiceXmlImplementationPlatform platform = new JVoiceXmlImplementationPlatform(this.telephonyPool, this.synthesizerPool, this.spokenInputPool, input, info);
            platform.init(this.configuration);
            return platform;
        }
        catch (ConfigurationException e) {
            throw new NoresourceError(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("closing implementation platforms...");
        }
        TerminationThread termination = new TerminationThread();
        termination.start();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("synthesizer pool has " + this.synthesizerPool.getNumActive() + " active/" + this.synthesizerPool.getNumIdle() + " idle objects");
        }
        try {
            this.synthesizerPool.close();
        }
        catch (Exception ex) {
            LOGGER.error("error closing synthesizer output pool", (Throwable)ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("spoken input pool has " + this.spokenInputPool.getNumActive() + " active/" + this.spokenInputPool.getNumIdle() + " idle objects");
        }
        try {
            this.spokenInputPool.close();
        }
        catch (Exception ex) {
            LOGGER.error("error closing spoken input output pool", (Throwable)ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("telephony pool has " + this.telephonyPool.getNumActive() + " active/" + this.telephonyPool.getNumIdle() + " idle objects");
        }
        try {
            this.telephonyPool.close();
        }
        catch (Exception ex) {
            LOGGER.error("error closing call control pool", (Throwable)ex);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("...implementation platforms closed");
        }
    }
}

