/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.CallControl;
import org.jvoicexml.CallControlProperties;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.ImplementationPlatform;
import org.jvoicexml.PromptAccumulator;
import org.jvoicexml.SpeakableSsmlText;
import org.jvoicexml.SpeakableText;
import org.jvoicexml.SystemOutput;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.plain.ConnectionDisconnectHangupEvent;

class JVoiceXmlPromptAccumulator
implements PromptAccumulator {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlPromptAccumulator.class);
    private final ImplementationPlatform platform;
    private long timeout;
    private final List<SpeakableText> prompts;

    JVoiceXmlPromptAccumulator(ImplementationPlatform implementationPlatform) {
        this.platform = implementationPlatform;
        this.prompts = new ArrayList<SpeakableText>();
        this.timeout = -1L;
    }

    @Override
    public void setPromptTimeout(long promptTimeout) {
        this.timeout = promptTimeout;
        this.prompts.clear();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("initial timeout after prompt queuing is " + this.timeout);
        }
    }

    public long getPromptTimeout() {
        return this.timeout;
    }

    @Override
    public void queuePrompt(SpeakableText speakable) {
        this.prompts.add(speakable);
    }

    public SpeakableText getLastSpeakableText() {
        int size = this.prompts.size();
        if (size == 0) {
            return null;
        }
        return this.prompts.get(size - 1);
    }

    @Override
    public void renderPrompts(String sessionId, DocumentServer server, CallControlProperties callProps) throws BadFetchError, NoresourceError, ConnectionDisconnectHangupEvent {
        CallControl call = this.platform.getCallControl();
        if (!call.isCallActive()) {
            throw new NoresourceError("cannot render prompts. call is no longer acttive");
        }
        SystemOutput output = this.platform.getSystemOutput();
        for (SpeakableText speakable : this.prompts) {
            SpeakableSsmlText ssmlSpeakable;
            long currentTimeout;
            if (speakable instanceof SpeakableSsmlText && (currentTimeout = (ssmlSpeakable = (SpeakableSsmlText)speakable).getTimeout()) >= 0L) {
                this.timeout = currentTimeout;
            }
            try {
                call.play(output, callProps);
            }
            catch (IOException e) {
                throw new BadFetchError("error playing to calling device", e);
            }
            output.queueSpeakable(speakable, sessionId, server);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("timeout after prompt queuing: " + this.timeout);
        }
    }
}

