/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.DocumentServer;
import org.jvoicexml.Session;
import org.jvoicexml.SpeakableText;
import org.jvoicexml.SystemOutput;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.implementation.SynthesizedOutput;
import org.jvoicexml.implementation.SynthesizedOutputListener;
import org.jvoicexml.implementation.SynthesizedOutputProvider;
import org.jvoicexml.xml.vxml.BargeInType;

final class JVoiceXmlSystemOutput
implements SystemOutput,
SynthesizedOutputProvider {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlSystemOutput.class);
    private final SynthesizedOutput synthesizedOutput;

    JVoiceXmlSystemOutput(SynthesizedOutput synthesizer, Session currentSession) {
        this.synthesizedOutput = synthesizer;
    }

    @Override
    public SynthesizedOutput getSynthesizedOutput() {
        return this.synthesizedOutput;
    }

    @Override
    public void queueSpeakable(SpeakableText speakable, String sessionId, DocumentServer documentServer) throws NoresourceError, BadFetchError {
        this.synthesizedOutput.queueSpeakable(speakable, sessionId, documentServer);
    }

    @Override
    public void cancelOutput(BargeInType type) throws NoresourceError {
        boolean supportsBargeIn = this.synthesizedOutput.supportsBargeIn();
        if (!supportsBargeIn) {
            LOGGER.warn("implementation platform does not support barge-in");
            return;
        }
        this.synthesizedOutput.cancelOutput(type);
    }

    public void addListener(SynthesizedOutputListener listener) {
        this.synthesizedOutput.addListener(listener);
    }

    public void removeListener(SynthesizedOutputListener listener) {
        this.synthesizedOutput.removeListener(listener);
    }

    public boolean isBusy() {
        return this.synthesizedOutput.isBusy();
    }
}

