/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.DtmfInput;
import org.jvoicexml.DtmfRecognizerProperties;
import org.jvoicexml.GrammarDocument;
import org.jvoicexml.SpeechRecognizerProperties;
import org.jvoicexml.UserInput;
import org.jvoicexml.event.error.BadFetchError;
import org.jvoicexml.event.error.NoresourceError;
import org.jvoicexml.event.error.UnsupportedFormatError;
import org.jvoicexml.event.error.UnsupportedLanguageError;
import org.jvoicexml.implementation.GrammarImplementation;
import org.jvoicexml.implementation.SpokenInput;
import org.jvoicexml.implementation.SpokenInputListener;
import org.jvoicexml.implementation.SpokenInputProvider;
import org.jvoicexml.implementation.dtmf.BufferedDtmfInput;
import org.jvoicexml.implementation.grammar.GrammarCache;
import org.jvoicexml.implementation.grammar.LoadedGrammar;
import org.jvoicexml.interpreter.datamodel.DataModel;
import org.jvoicexml.xml.srgs.GrammarType;
import org.jvoicexml.xml.srgs.ModeType;
import org.jvoicexml.xml.vxml.BargeInType;

final class JVoiceXmlUserInput
implements UserInput,
SpokenInputProvider {
    private static final Logger LOGGER = LogManager.getLogger(JVoiceXmlUserInput.class);
    private final BufferedDtmfInput dtmfInput;
    private final SpokenInput spokenInput;
    private final GrammarCache cache;

    JVoiceXmlUserInput(SpokenInput input, BufferedDtmfInput dtmf) {
        this.spokenInput = input;
        this.dtmfInput = dtmf;
        this.cache = new GrammarCache();
    }

    @Override
    public SpokenInput getSpokenInput() {
        return this.spokenInput;
    }

    public DtmfInput getDtmfInput() {
        return this.dtmfInput;
    }

    @Override
    public int activateGrammars(Collection<GrammarDocument> grammars) throws BadFetchError, UnsupportedLanguageError, NoresourceError, UnsupportedFormatError {
        ArrayList voiceGrammars = new ArrayList();
        ArrayList dtmfGrammars = new ArrayList();
        for (GrammarDocument grammar : grammars) {
            GrammarImplementation<?> grammarImplementation = this.loadGrammar(grammar);
            ModeType type = grammarImplementation.getModeType();
            if (type == ModeType.DTMF) {
                dtmfGrammars.add(grammarImplementation);
                continue;
            }
            voiceGrammars.add(grammarImplementation);
        }
        if (!voiceGrammars.isEmpty()) {
            this.spokenInput.activateGrammars(voiceGrammars);
        }
        if (this.dtmfInput != null && !dtmfGrammars.isEmpty()) {
            this.dtmfInput.activateGrammars(dtmfGrammars);
        }
        return voiceGrammars.size() + dtmfGrammars.size();
    }

    @Override
    public int deactivateGrammars(Collection<GrammarDocument> grammars) throws NoresourceError, BadFetchError {
        ArrayList voiceGrammars = new ArrayList();
        ArrayList dtmfGrammars = new ArrayList();
        for (GrammarDocument grammar : grammars) {
            GrammarImplementation<?> impl = this.cache.getImplementation(grammar);
            if (impl == null) {
                LOGGER.warn("no implementation for grammar " + grammar);
                continue;
            }
            ModeType type = grammar.getModeType();
            if (type == ModeType.DTMF) {
                dtmfGrammars.add(impl);
                continue;
            }
            voiceGrammars.add(impl);
        }
        if (!voiceGrammars.isEmpty()) {
            this.spokenInput.deactivateGrammars(voiceGrammars);
        }
        if (this.dtmfInput != null && !dtmfGrammars.isEmpty()) {
            this.dtmfInput.deactivateGrammars(dtmfGrammars);
        }
        return voiceGrammars.size() + dtmfGrammars.size();
    }

    @Override
    public Collection<BargeInType> getSupportedBargeInTypes() {
        return this.spokenInput.getSupportedBargeInTypes();
    }

    private GrammarImplementation<?> loadGrammar(GrammarDocument document) throws NoresourceError, BadFetchError, UnsupportedFormatError {
        URI uri = document.getURI();
        if (this.cache.contains(document)) {
            LOGGER.info("grammar from '" + uri + "' already loaded");
            return this.cache.getImplementation(document);
        }
        GrammarType type = document.getMediaType();
        ModeType mode = document.getModeType();
        try {
            LOGGER.info("loading '" + type + "' grammar from '" + uri + "'");
            GrammarImplementation<?> implementation = mode == ModeType.DTMF ? this.dtmfInput.loadGrammar(uri, type) : this.spokenInput.loadGrammar(uri, type);
            LoadedGrammar loaded = new LoadedGrammar(document, implementation);
            this.cache.add(loaded);
            return implementation;
        }
        catch (IOException e) {
            throw new BadFetchError(e.getMessage(), e);
        }
    }

    public void addListener(SpokenInputListener listener) {
        this.spokenInput.addListener(listener);
        if (this.dtmfInput != null) {
            this.dtmfInput.addListener(listener);
        }
    }

    public void removeListener(SpokenInputListener listener) {
        this.spokenInput.removeListener(listener);
        if (this.dtmfInput != null) {
            this.dtmfInput.removeListener(listener);
        }
    }

    @Override
    public void startRecognition(DataModel model, Collection<ModeType> types, SpeechRecognizerProperties speech, DtmfRecognizerProperties dtmf) throws NoresourceError, BadFetchError {
        if (types.contains(ModeType.VOICE)) {
            this.spokenInput.startRecognition(model, speech, dtmf);
        }
        if (this.dtmfInput != null && types.contains(ModeType.DTMF)) {
            this.dtmfInput.startRecognition(model, speech, dtmf);
        }
    }

    @Override
    public void stopRecognition(Collection<ModeType> types) {
        if (types == null || types.contains(ModeType.VOICE)) {
            this.spokenInput.stopRecognition();
        }
        if (this.dtmfInput != null && (types == null || types.contains(ModeType.DTMF))) {
            this.dtmfInput.stopRecognition();
        }
    }

    @Override
    public Collection<GrammarType> getSupportedGrammarTypes(ModeType mode) {
        if (mode == ModeType.DTMF) {
            ArrayList<GrammarType> types = new ArrayList<GrammarType>();
            types.add(GrammarType.SRGS_XML);
            return types;
        }
        return this.spokenInput.getSupportedGrammarTypes();
    }

    public boolean isBusy() {
        return this.spokenInput.isBusy();
    }
}

