/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class RecordingThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(RecordingThread.class);
    private static final int BUFFER_SIZE = 512;
    private final OutputStream out;
    private final TargetDataLine line;
    private final AudioFormat format;
    private boolean shouldStop;

    RecordingThread(OutputStream stream, AudioFormat recordingFormat) throws LineUnavailableException {
        this.out = stream;
        this.format = recordingFormat;
        this.shouldStop = false;
        this.setDaemon(true);
        this.setName("RecordingThread");
        this.line = AudioSystem.getTargetDataLine(this.format);
        this.line.open();
    }

    @Override
    public void run() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("recording started");
        }
        try {
            this.line.start();
            byte[] buffer = new byte[512];
            while (!this.shouldStop) {
                int count = this.line.read(buffer, 0, buffer.length);
                if (count <= 0) continue;
                this.out.write(buffer, 0, count);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("recording stopped");
        }
    }

    public void stopRecording() {
        this.line.stop();
        this.line.close();
        this.shouldStop = true;
    }
}

