/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

final class SpeakerOutputStream
extends OutputStream
implements LineListener {
    private final SourceDataLine line;

    SpeakerOutputStream(AudioFormat format) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        this.line.addLineListener(this);
        this.line.open(format);
    }

    public void open() throws IOException {
        this.line.start();
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.line.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int len) throws IOException {
        this.line.write(bytes, offset, len);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.line.write(bytes, 0, bytes.length);
    }

    @Override
    public void flush() throws IOException {
        this.line.drain();
    }

    @Override
    public void close() throws IOException {
        if (this.line != null) {
            this.line.close();
        }
        super.close();
    }

    @Override
    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.CLOSE || event.getType() == LineEvent.Type.STOP) {
            // empty if block
        }
    }
}

