/*
 * Decompiled with CFR 0.152.
 */
package org.jvoicexml.implementation.jvxml;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jvoicexml.event.EventBus;
import org.jvoicexml.event.plain.NoinputEvent;

final class TimerThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(TimerThread.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private boolean stopped;
    private final EventBus eventbus;
    private final Object semaphor;
    private final long timeout;

    TimerThread(EventBus bus, long delay) {
        this.setDaemon(true);
        this.setName("noinput-TimerThread");
        this.eventbus = bus;
        this.timeout = delay > 0L ? delay : 30000L;
        this.semaphor = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.info("timer thread started with a delay of " + this.timeout + " msec");
        try {
            Object object = this.semaphor;
            synchronized (object) {
                this.semaphor.wait(this.timeout);
            }
        }
        catch (InterruptedException ie) {
            LOGGER.error("error waiting for input timeout");
        }
        if (!this.stopped) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("sending no input event");
            }
            NoinputEvent event = new NoinputEvent();
            this.eventbus.publish(event);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("timer thread terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("stopping timer...");
        }
        if (this.eventbus != null) {
            this.stopped = true;
        }
        Object object = this.semaphor;
        synchronized (object) {
            this.semaphor.notifyAll();
        }
    }
}

